/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.impl.x73.dim;

import gov.nist.healthcare.dev.profile.dao.DimDao;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimBehavior;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimNotification;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.EntiCardinality;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;

public abstract class AbstractDimDaoImpl
implements DimDao {
    private static final Logger log = Logger.getLogger(AbstractDimDaoImpl.class.getName());

    public static DimObject NullProtection(DimObject obj) {
        String ret = "";
        obj.setName(AbstractDimDaoImpl.NullProtection(ret, obj.getName()));
        obj.setRefid(AbstractDimDaoImpl.NullProtection(ret, obj.getRefid()));
        return obj;
    }

    private static String NullProtection(String _ret, String input) {
        String ret = new String(_ret);
        if (input != null && !input.equals("")) {
            ret = new String(input);
        }
        return ret;
    }

    @Override
    public List<DimAttribute> getAllAttributes() {
        List ret = this.getEntityManager().createQuery("SELECT e FROM DimAttribute e ORDER BY  e.name ASC ").getResultList();
        return ret;
    }

    @Override
    public List<DimBehavior> getAllBehaviors() {
        List ret = this.getEntityManager().createQuery("SELECT e FROM DimBehavior e ORDER BY  e.name ASC ").getResultList();
        return ret;
    }

    @Override
    public List<DimNotification> getAllNotications() {
        List ret = this.getEntityManager().createQuery("SELECT e FROM DimNotification e ORDER BY  e.refid ASC ").getResultList();
        return ret;
    }

    @Override
    public DimAttribute getAttributeByReferenceId(String refid) {
        DimAttribute ret = (DimAttribute)this.getEntityManager().createQuery("SELECT e FROM DimAttribute e WHERE e.refid LIKE :refid ").setParameter("refid", (Object)refid).getResultList().get(0);
        return ret;
    }

    public abstract EntityManager getEntityManager();

    @Override
    public DimObject getObject(DimObject obj) {
        return this.getValidatedDimObject(obj);
    }

    @Override
    public DimObject getObjectByName(String name) {
        DimObject ret = (DimObject)this.getEntityManager().createQuery("SELECT e FROM DimObject e WHERE e.name LIKE :name").setParameter("name", (Object)name).getResultList().get(0);
        return ret;
    }

    @Override
    public DimObject getObjectByReferenceId(String refid) {
        List objs = this.getEntityManager().createQuery("SELECT e FROM DimObject e WHERE e.refid LIKE :refid").setParameter("refid", (Object)refid).getResultList();
        DimObject ret = null;
        if (objs.size() > 0) {
            ret = (DimObject)objs.get(0);
        }
        return ret;
    }

    @Override
    public List<DimObject> getObjectChildren(DimObject obj) {
        ArrayList<DimObject> childrenRet = new ArrayList<DimObject>();
        if (obj == null) {
            return childrenRet;
        }
        DimObject searchObj = this.getObject(obj);
        if (searchObj != null) {
            List cardList = searchObj.getCardinalities();
            for (EntiCardinality card : cardList) {
                try {
                    childrenRet.add((DimObject)card.getChildObject().clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
        return childrenRet;
    }

    @Override
    public List<DimObject> getObjectList(DimObject obj) {
        String refid = (obj = AbstractDimDaoImpl.NullProtection(obj)).getRefid().equals("") ? "%" : obj.getRefid();
        String name = obj.getName().equals("") ? "%" : obj.getName();
        return this.getEntityManager().createQuery("SELECT e FROM DimObject e WHERE e.name LIKE :name AND e.refid LIKE :refid").setParameter("name", (Object)name).setParameter("refid", (Object)refid).getResultList();
    }

    @Override
    public DimObject getObjectRoot() {
        DimObject dimRoot = new DimObject();
        dimRoot.setName("DIM");
        dimRoot.setRefid("DIM");
        dimRoot = this.getValidatedDimObject(dimRoot);
        return dimRoot;
    }

    @Override
    public List<DimObject> getObjects() {
        List ret = this.getEntityManager().createQuery("SELECT e FROM DimObject e ORDER BY  e.refid DESC ").getResultList();
        return ret;
    }

    public DimObject getValidatedDimObject(DimObject obj) {
        List<DimObject> objList = this.getObjectList(obj);
        if (objList.size() > 0) {
            if (objList.size() > 1) {
                log.warning("Size " + objList.size() + " > 1" + " " + obj.getName() + " " + objList.get(0) + " " + objList.get(1));
            }
            try {
                return (DimObject)objList.get(0).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

