/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.guice.rest;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import gov.nist.healthcare.dev.profile.dao.NomnDao;
import gov.nist.healthcare.deviceProfile.domain.rtmms.nomenclature.Coded_term;
import java.util.ArrayList;
import java.util.List;

public class NomnDaoRestImpl
implements NomnDao {
    private final Client client;
    private final String webrss;

    @Inject
    public NomnDaoRestImpl(@Named(value="NOMN_REST_ADDR") String webrss) {
        this.webrss = webrss;
        this.client = Client.create();
    }

    @Override
    public List<Coded_term> find(String keyword) {
        WebResource rss = this.client.resource(this.webrss + "find/" + keyword);
        return this.get(rss);
    }

    @Override
    public List<Coded_term> getAll() {
        WebResource rss = this.client.resource(this.webrss + "all/");
        return this.get(rss);
    }

    @Override
    public Coded_term getTermById(Integer id) {
        WebResource rss = this.client.resource(this.webrss + "id/" + id);
        Coded_term ret = (Coded_term)rss.get(Coded_term.class);
        return ret;
    }

    @Override
    public List<Coded_term> getTermsByReferenceId(String ref_id) {
        try {
            WebResource rss = this.client.resource(this.webrss + "get/" + ref_id);
            return this.get(rss);
        }
        catch (Exception e) {
            return new ArrayList<Coded_term>();
        }
    }

    @Override
    public void persist(Coded_term obj) {
    }

    private List<Coded_term> get(WebResource rss) {
        ArrayList ret = (ArrayList)rss.accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Coded_term>>(){});
        if (ret == null) {
            ret = new ArrayList();
        }
        return ret;
    }
}

