/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.tree;

import gov.nist.healthcare.mdc.applib.tree.TreeToolbar;
import gov.nist.healthcare.mdc.applib.tree.TreeTransferHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePanel
extends JPanel {
    public List<JMenuItem> menuItemList = new ArrayList<JMenuItem>();
    public JMenu menuMouseAdd;
    public JMenuItem menuMouseRemove;
    public JPopupMenu popUpMouseMenu;
    public TreeToolbar treeToolbar;
    protected ActionListener actionListener;
    protected JTree tree;

    public TreePanel(TreeSelectionListener listener, ActionListener actionListener, DefaultTreeCellRenderer renderer) {
        this.actionListener = actionListener;
        this.treeToolbar = new TreeToolbar(actionListener);
        this.initComponent(listener, renderer);
    }

    public List<JMenuItem> buildAddMenu(List<String> childNameList) {
        this.menuItemList = new ArrayList<JMenuItem>();
        this.menuMouseAdd.removeAll();
        this.treeToolbar.addMenu.removeAll();
        if (childNameList.size() == 0) {
            JMenuItem menuItem = new JMenuItem("No follower");
            this.menuMouseAdd.add(menuItem);
            JMenuItem toolbarmenuItem = new JMenuItem("No follower");
            this.treeToolbar.addMenu.add(toolbarmenuItem);
            return this.menuItemList;
        }
        for (String s : childNameList) {
            JMenuItem menuItem = new JMenuItem(s);
            menuItem.addActionListener(this.actionListener);
            this.menuMouseAdd.add(menuItem);
            this.menuItemList.add(menuItem);
            JMenuItem toolbarmenuItem = new JMenuItem(s);
            toolbarmenuItem.addActionListener(this.actionListener);
            this.treeToolbar.addMenu.add(toolbarmenuItem);
            this.menuItemList.add(toolbarmenuItem);
        }
        return this.menuItemList;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setModel(TreeModel model) {
        if (model != null) {
            this.getTree().setModel(model);
            this.getTree().setRootVisible(true);
            this.expandTree(this.getTree());
            Object[] path = ((DefaultMutableTreeNode)this.getTree().getModel().getRoot()).getPath();
            TreePath treePath = new TreePath(path);
            this.getTree().addSelectionPath(treePath);
            this.getTree().scrollPathToVisible(treePath);
            this.getTree().updateUI();
        }
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void expandTree(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), true);
    }

    private void initComponent(TreeSelectionListener listener, DefaultTreeCellRenderer renderer) {
        this.tree = new JTree(new Vector());
        this.tree.setDragEnabled(true);
        this.tree.setDropMode(DropMode.ON_OR_INSERT);
        this.tree.setTransferHandler(new TreeTransferHandler());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(listener);
        this.tree.addMouseListener(new TreeMouseAdapter());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
        this.add((Component)this.treeToolbar, "North");
        this.menuMouseAdd = new JMenu("Add");
        this.menuMouseRemove = new JMenuItem("Remove");
        this.menuMouseRemove.addActionListener(this.actionListener);
        this.popUpMouseMenu = new JPopupMenu();
        this.popUpMouseMenu.add(this.menuMouseAdd);
        this.popUpMouseMenu.add(this.menuMouseRemove);
    }

    class TreeMouseAdapter
    extends MouseAdapter {
        TreeMouseAdapter() {
        }

        public void displayMenu(MouseEvent e) {
            if (TreePanel.this.tree != null && e.isPopupTrigger()) {
                DefaultMutableTreeNode defRootNode = (DefaultMutableTreeNode)TreePanel.this.tree.getModel().getRoot();
                TreePath path = TreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    TreePanel.this.tree.setSelectionPath(path);
                    if (TreePanel.this.tree.getLastSelectedPathComponent().equals(defRootNode)) {
                        // empty if block
                    }
                    TreePanel.this.popUpMouseMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                this.displayMenu(e);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

