/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.box.table;

import gov.nist.healthcare.mdc.applib.box.DefaultBox;
import gov.nist.healthcare.mdc.applib.box.table.ItemClickActioner;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditModel;
import gov.nist.healthcare.mdc.applib.table.ICSTableScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class TableBox
extends DefaultBox
implements ActionListener {
    private static final Logger log = Logger.getLogger(TableBox.class.getName());
    protected JButton editButton;
    protected JButton deleteButton;
    protected ItemClickActioner itemClickActioner;
    protected ICSTableScrollPane tablePane;
    protected Vector<ListEditModel> tableRowList = new Vector();
    private int maxRowCount = 5;

    public TableBox(String label) {
        super(label);
        this.createGUI();
    }

    public TableBox(String label, int maxrow) {
        super(label);
        this.maxRowCount = maxrow;
        this.createGUI();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.editButton) {
            this.editButtonClicked();
        } else if (evt.getSource() == this.deleteButton) {
            this.deleteButtonClicked();
        }
    }

    @Override
    public void createGUI() {
        this.tablePane = new ICSTableScrollPane();
        ListSelectionListener listSelectionlistener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel rowSM = (ListSelectionModel)evt.getSource();
                int selectedIndex = rowSM.getMinSelectionIndex();
                TableBox.this.itemClicked();
            }
        };
        this.tablePane.getTable().getSelectionModel().addListSelectionListener(listSelectionlistener);
        this.tablePane.getTable().maxRowCount = this.maxRowCount;
        this.addComponent(this.tablePane);
        this.setCollapsable(true);
        this.getView().addComponentListener(new ICSTableScrollPane.TablePaneCompAdapter(this.tablePane));
    }

    public void deleteButtonClicked() {
    }

    public void editButtonClicked() {
    }

    public ItemClickActioner getItemClickActioner() {
        return this.itemClickActioner;
    }

    public JTable getTable() {
        return this.tablePane.getTable();
    }

    public void itemClicked() {
        if (this.itemClickActioner != null) {
            this.itemClickActioner.clickedAction();
        }
    }

    @Override
    public void refresh() {
        this.tablePane.refresh();
    }

    public void setItemClickActioner(ItemClickActioner itemClickReationer) {
        this.itemClickActioner = itemClickReationer;
    }

    public void setModel(AbstractTableModel dataModel) {
        this.tablePane.setModel(dataModel);
    }

    protected void clearTableRow() {
        this.tableRowList.clear();
        this.setModel(this.getDefaultTableModel(this.tableRowList));
    }

    protected DefaultTableModel getDefaultTableModel(List<ListEditModel> modelList) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        return defaultTableModel;
    }

    protected void setupTableRow(List<?> objs) {
        this.clearTableRow();
        for (Object obj : objs) {
            this.tableRowList.add(new ListEditModel(obj, true));
        }
        this.setModel(this.getDefaultTableModel(this.tableRowList));
    }

    protected void setupToolbar() {
        this.editButton = new JButton();
        this.editButton.setText("Edit ");
        this.editButton.setToolTipText("Edit " + this.boxLabel);
        this.editButton.setFocusable(false);
        this.editButton.setIcon(TableBox.getImageIcon("EDITICON"));
        this.editButton.addActionListener(this);
        this.deleteButton = new JButton();
        this.deleteButton.setToolTipText("Remove");
        this.deleteButton.setFocusable(false);
        this.deleteButton.setIcon(TableBox.getImageIcon("REMOVEICON"));
        this.deleteButton.addActionListener(this);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.editButton);
        toolBar.add(this.deleteButton);
        JPanel optionPanelToolBar = new JPanel();
        optionPanelToolBar.setLayout(new BoxLayout(optionPanelToolBar, 2));
        optionPanelToolBar.add(toolBar);
        this.setHeadComponent(optionPanelToolBar);
    }

    protected void updateEditButtonTxt(Vector<ListEditModel> currentNodeModel) {
        int i = 0;
        for (ListEditModel le : currentNodeModel) {
            if (le.isInDestList().booleanValue()) continue;
            ++i;
        }
        if (this.editButton != null) {
            if (i > 0) {
                this.editButton.setText(" (" + i + ")");
            } else {
                this.editButton.setText("");
            }
        }
    }
}

