/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.autocompletion.textfield;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;

class ListPopup
extends JPopupMenu
implements MouseInputListener {
    private static final long serialVersionUID = 1L;
    private final JList list;
    private final ArrayList<ListSelectionListener> listeners = new ArrayList();
    private final JScrollPane pane;

    public ListPopup() {
        this.setLayout(new BorderLayout());
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this);
        this.list.addMouseMotionListener(this);
        this.list.setModel(new DefaultListModel());
        this.pane = new JScrollPane(this.list);
        this.pane.setBorder(null);
        this.add((Component)this.pane, "Center");
    }

    public void addItem(Object o) {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.addElement(o);
        this.list.repaint();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public Object getItem(int index) {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        return model.get(index);
    }

    public int getItemCount() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        return model.getSize();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public boolean isSelected() {
        return this.list.getSelectedIndex() != -1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent anEvent) {
        if (anEvent.getSource() == this.list) {
            Point location = anEvent.getPoint();
            Rectangle r = new Rectangle();
            this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                this.updateListBoxSelectionForEvent(anEvent, false);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.list.getSelectedIndex() != -1) {
            this.fireValueChanged(new ListSelectionEvent(this.list, this.list.getSelectedIndex(), this.list.getSelectedIndex(), true));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void removeItem(Object o) {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.removeElement(o);
        this.list.repaint();
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public void setLastOneSelected() {
        int count = this.list.getModel().getSize();
        if (count > 0) {
            this.list.ensureIndexIsVisible(count - 1);
            this.list.setSelectedIndex(count - 1);
        }
    }

    public void setList(Enumeration e) {
        DefaultListModel model = new DefaultListModel();
        while (e.hasMoreElements()) {
            model.addElement(e.nextElement());
        }
        this.list.setModel(model);
        this.list.repaint();
    }

    public void setList(Iterable iterable) {
        DefaultListModel model = new DefaultListModel();
        for (Object o : iterable) {
            model.addElement(o);
        }
        this.list.setModel(model);
        this.list.repaint();
    }

    public void setList(Object ... objects) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (Object o : objects) {
            model.addElement(o);
        }
        this.list.setModel(model);
        this.list.repaint();
    }

    public void setSelectedIndex(int index) {
        if (index >= this.list.getModel().getSize()) {
            index = 0;
        }
        if (index < 0) {
            index = this.list.getModel().getSize() - 1;
        }
        this.list.ensureIndexIsVisible(index);
        this.list.setSelectedIndex(index);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.list.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    private void fireValueChanged(ListSelectionEvent e) {
        for (ListSelectionListener l : this.listeners) {
            l.valueChanged(e);
        }
    }
}

