/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.autocompletion;

import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompleteCombo
extends JComboBox {
    private static final Logger logger = Logger.getLogger(AutoCompleteCombo.class.getName());
    private final AutoCompleteComboBoxModel model = new AutoCompleteComboBoxModel();
    private boolean modelFilling = false;
    private String previousPattern = null;
    private final JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
    private boolean updatePopup;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCompleteCombo combo = new AutoCompleteCombo();
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.setLayout(new GridLayout(3, 1));
                frame.add(combo);
                frame.pack();
                frame.setSize(500, frame.getHeight());
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public AutoCompleteCombo() {
        this.setEditable(true);
        logger.info("setPattern() called from constructor");
        this.setPattern(null);
        this.updatePopup = false;
        this.textComponent.setDocument(new AutoCompleteDocument());
        this.setModel(this.model);
        this.setSelectedItem(null);
        new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutoCompleteCombo.this.updatePopup && AutoCompleteCombo.this.isDisplayable()) {
                    AutoCompleteCombo.this.setPopupVisible(false);
                    if (AutoCompleteCombo.this.model.getSize() > 0) {
                        AutoCompleteCombo.this.setPopupVisible(true);
                    }
                    AutoCompleteCombo.this.updatePopup = false;
                }
            }
        }).start();
    }

    public synchronized void addToTop(String aString) {
        this.model.addToTop(aString);
    }

    public String getText() {
        return this.getEditor().getItem().toString();
    }

    public void setText(String text) {
        if (this.model.data.contains(text)) {
            this.setSelectedItem(text);
        } else {
            this.addToTop(text);
            this.setSelectedIndex(0);
        }
    }

    private void clearSelection() {
        int i = this.getText().length();
        this.textComponent.setSelectionStart(i);
        this.textComponent.setSelectionEnd(i);
    }

    private void setPattern(String pattern) {
        if (pattern != null && pattern.trim().isEmpty()) {
            pattern = null;
        }
        if (this.previousPattern == null && pattern == null || pattern != null && pattern.equals(this.previousPattern)) {
            logger.info("[setPatter] pattern is the same as previous: " + this.previousPattern);
            return;
        }
        this.previousPattern = pattern;
        this.modelFilling = true;
        this.model.setPattern(pattern);
        StringBuilder b = new StringBuilder(100);
        b.append("pattern filter '").append(pattern == null ? "null" : pattern).append("' set:\n");
        for (int i = 0; i < this.model.getSize(); ++i) {
            b.append(", ").append('[').append(this.model.getElementAt(i)).append(']');
        }
        int ind = b.indexOf(", ");
        if (ind != -1) {
            b.delete(ind, ind + 2);
        }
        logger.info(b.toString());
        this.modelFilling = false;
        if (pattern != null) {
            this.updatePopup = true;
        }
    }

    private class AutoCompleteDocument
    extends PlainDocument {
        boolean arrowKeyPressed = false;

        public AutoCompleteDocument() {
            AutoCompleteCombo.this.textComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        logger.info("[key listener] enter key pressed");
                        String text = AutoCompleteCombo.this.textComponent.getText();
                        if (!((AutoCompleteCombo)AutoCompleteCombo.this).model.data.contains(text)) {
                            logger.info("addToTop() called from keyPressed()");
                            AutoCompleteCombo.this.addToTop(text);
                        }
                    } else if (key == 38 || key == 40) {
                        AutoCompleteDocument.this.arrowKeyPressed = true;
                        logger.info("arrow key pressed");
                    }
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (AutoCompleteCombo.this.modelFilling) {
                logger.info("[insert] model is being filled now");
                return;
            }
            super.insertString(offs, str, a);
            String text = this.getText(0, this.getLength());
            if (this.arrowKeyPressed) {
                logger.info("[insert] arrow key was pressed, updateModel() was NOT called");
                AutoCompleteCombo.this.model.setSelectedItem(text);
                logger.info(String.format("[insert] model.setSelectedItem(%s)", text));
                this.arrowKeyPressed = false;
            } else if (!text.equals(AutoCompleteCombo.this.getSelectedItem())) {
                logger.info("[insert] calling updateModel()");
                this.updateModel();
            }
            AutoCompleteCombo.this.clearSelection();
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (AutoCompleteCombo.this.modelFilling) {
                logger.info("[remove] model is being filled now");
                return;
            }
            super.remove(offs, len);
            if (this.arrowKeyPressed) {
                this.arrowKeyPressed = false;
                logger.info("[remove] arrow key was pressed, updateModel() was NOT called");
            } else {
                logger.info("[remove] calling updateModel()");
                this.updateModel();
            }
            AutoCompleteCombo.this.clearSelection();
        }

        void updateModel() throws BadLocationException {
            String textToMatch = this.getText(0, this.getLength());
            logger.info("setPattern() called from updateModel()");
            AutoCompleteCombo.this.setPattern(textToMatch);
        }
    }

    private class AutoCompleteComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        AutoCompleteComboBoxModelData data = new AutoCompleteComboBoxModelData();
        final String delimiter = ";;;";
        boolean isThreadStarted = false;
        final int limit = 20;
        String selected;

        public AutoCompleteComboBoxModel() {
            this.readData();
        }

        public void addToTop(String aString) {
            if (aString == null || this.data.contains(aString)) {
                return;
            }
            if (this.data.size() == 0) {
                this.data.add(aString);
            } else {
                this.data.addToTop(aString);
            }
            while (this.data.size() > 20) {
                int index = this.data.size() - 1;
                this.data.remove(index);
            }
            this.setPattern(null);
            AutoCompleteCombo.this.model.setSelectedItem(aString);
            logger.info(String.format("[addToTop] model.setSelectedItem(%s)", aString));
            if (this.data.size() > 0) {
                this.writeData();
            }
        }

        @Override
        public Object getElementAt(int index) {
            return this.data.getFiltered().get(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.data.getFiltered().size();
        }

        public void setPattern(String pattern) {
            int size1 = this.getSize();
            this.data.setPattern(pattern);
            int size2 = this.getSize();
            if (size1 < size2) {
                this.fireIntervalAdded(this, size1, size2 - 1);
                this.fireContentsChanged(this, 0, size1 - 1);
            } else if (size1 > size2) {
                this.fireIntervalRemoved(this, size2, size1 - 1);
                this.fireContentsChanged(this, 0, size2 - 1);
            }
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this.selected != null && !this.selected.equals(anObject) || this.selected == null && anObject != null) {
                this.selected = (String)anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        void readData() {
            String[] countries;
            for (String country : countries = new String[]{"Afghanistan", "Albania", "Algeria", "Andorra", "Angola", "Argentina", "Armenia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Benin", "Bhutan", "Bolivia", "Bosnia & Herzegovina", "Botswana", "Brazil", "Bulgaria", "Burkina Faso", "Burma", "Burundi", "Cambodia", "Cameroon", "Canada", "China", "Colombia", "Comoros", "Congo", "Croatia", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Georgia", "Germany", "Ghana", "Great Britain", "Greece", "Somalia", "Spain", "Sri Lanka", "Sudan", "Suriname", "Swaziland", "Sweden", "Switzerland", "Syria", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Yemen", "Zaire", "Zambia", "Zimbabwe"}) {
                this.data.add(country);
            }
        }

        void writeData() {
            StringBuilder b = new StringBuilder(1200);
            for (String url : this.data.getList()) {
                b.append(";;;").append(url);
            }
            b.delete(0, ";;;".length());
            if (this.isThreadStarted) {
                return;
            }
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AutoCompleteCombo autoCompleteCombo = AutoCompleteCombo.this;
                    synchronized (autoCompleteCombo) {
                        AutoCompleteComboBoxModel.this.isThreadStarted = false;
                    }
                }
            }).start();
            this.isThreadStarted = true;
        }

        class AutoCompleteComboBoxModelData {
            private List<String> filtered;
            private final List<String> list = new ArrayList<String>(20);
            private final List<String> lowercase = new ArrayList<String>(20);

            AutoCompleteComboBoxModelData() {
            }

            void add(String s) {
                this.list.add(s);
                this.lowercase.add(s.toLowerCase());
            }

            void addToTop(String s) {
                this.list.add(0, s);
                this.lowercase.add(0, s.toLowerCase());
            }

            boolean contains(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return true;
                }
                s = s.toLowerCase();
                for (String item : this.lowercase) {
                    if (!item.equals(s)) continue;
                    return true;
                }
                return false;
            }

            List<String> getFiltered() {
                if (this.filtered == null) {
                    this.filtered = this.list;
                }
                return this.filtered;
            }

            List<String> getList() {
                return this.list;
            }

            void remove(int index) {
                this.list.remove(index);
                this.lowercase.remove(index);
            }

            void setPattern(String pattern) {
                if (pattern == null || pattern.isEmpty()) {
                    this.filtered = this.list;
                    AutoCompleteCombo.this.setSelectedItem(AutoCompleteCombo.this.model.getElementAt(0));
                    logger.info(String.format("[setPattern] combo.setSelectedItem(null)", new Object[0]));
                } else {
                    this.filtered = new ArrayList<String>(20);
                    pattern = pattern.toLowerCase();
                    for (int i = 0; i < this.lowercase.size(); ++i) {
                        if (!this.lowercase.get(i).contains(pattern)) continue;
                        this.filtered.add(this.list.get(i));
                    }
                    AutoCompleteCombo.this.setSelectedItem(pattern);
                    logger.info(String.format("[setPattern] combo.setSelectedItem(%s)", pattern));
                }
                logger.info(String.format("pattern:'%s', filtered: %s", pattern, this.filtered));
            }

            int size() {
                return this.list.size();
            }
        }
    }
}

