/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib;

import gov.nist.healthcare.mdc.framework.StandaloneResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow
implements Runnable {
    private static volatile int duration = 10;
    private JProgressBar progressbar;

    public static synchronized int getDuration() {
        return duration;
    }

    public static synchronized void setDuration(int duration) {
        SplashScreen.duration = duration;
    }

    @Override
    public void run() {
        this.showSplash();
        for (int i = 0; i < 100 && duration <= 100; ++i) {
            SplashScreen.setDuration(SplashScreen.getDuration() + 2);
            this.progressbar.setValue(SplashScreen.getDuration());
            try {
                Thread.yield();
                Thread.sleep(350L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setVisible(false);
    }

    public void showSplash() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screen.width;
        int screenHeight = screen.height;
        int width = 530;
        int height = 350;
        this.setSize(new Dimension(width, height));
        this.setLocationRelativeTo(null);
        JLabel label = new JLabel(StandaloneResourceManager.getInstance().getImageIcon("resources/application/images/logo.png"));
        JLabel copyrt = new JLabel("", 0);
        copyrt.setFont(new Font("Sans-Serif", 1, 12));
        this.progressbar = new JProgressBar();
        this.progressbar.setOrientation(0);
        this.progressbar.setMinimum(0);
        this.progressbar.setMaximum(100);
        this.progressbar.setValue(20);
        this.progressbar.setStringPainted(false);
        this.progressbar.setPreferredSize(new Dimension(300, 20));
        this.progressbar.setBorderPainted(true);
        this.progressbar.setBackground(Color.pink);
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(Color.white);
        content.add((Component)label, "Center");
        content.add((Component)this.progressbar, "South");
        Color oraRed = new Color(156, 20, 20, 255);
        content.setBorder(BorderFactory.createLineBorder(oraRed, 1));
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }
}

