/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileLocSelector {
    public static File fileLocationSelecter(Component parent, String defaultDir, String fileExtension, int saveOrOpenDialog, FileFilter filter) {
        File selFile = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(saveOrOpenDialog);
        chooser.setCurrentDirectory(new File(defaultDir));
        chooser.setFileFilter(filter);
        int returnVal = saveOrOpenDialog == 0 ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
        if (returnVal == 0) {
            try {
                boolean save = true;
                selFile = chooser.getSelectedFile();
                if (!selFile.getPath().endsWith(fileExtension)) {
                    selFile = new File(selFile.getPath() + fileExtension);
                }
                if (saveOrOpenDialog == 1 && selFile.exists()) {
                    save = false;
                    returnVal = JOptionPane.showConfirmDialog(chooser, selFile.getAbsolutePath() + " already exists. Do you want to replace it?", "Warning", 0, 2);
                    if (returnVal == 0) {
                        save = true;
                    }
                }
                if (!save) {
                    selFile = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                selFile = null;
            }
        }
        return selFile;
    }

    public static File showDialog(Component parent, String defaultDir, String fileExtension, int saveOrOpenDialog, FileFilter filter) {
        return FileLocSelector.fileLocationSelecter(parent, defaultDir, fileExtension, saveOrOpenDialog, filter);
    }
}

