/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model;

import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Attribute;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Behavior;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Notification;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73ObjectBase;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class X73DimObject
extends X73ObjectBase {
    protected String _moc_application_guidance = "";
    protected String _moc_comment = "";
    protected String _moc_restrictions = "";
    protected String _moc_support = "";
    protected String _mocLabel = "";
    protected String _mocRefId = "";
    protected String _mocTermCode = "";
    protected String _object_id = "";
    protected String _object_name = "";
    protected String _object_reference = "";
    protected String _object_termcode = "";
    protected Vector<X73DimObject> dimObjList = new Vector();
    protected Integer object_profile_id = -1;
    protected List<Integer> object_profile_parent_id = new ArrayList<Integer>();
    protected Vector<X73Attribute> vAttribute = new Vector();
    protected Vector<X73Behavior> vBehavior = new Vector();
    protected Vector<X73Notification> vNotification = new Vector();
    private String additionalObj = "";
    private boolean bool_private_moc = false;
    private String privateObj = "";
    private String status = "";

    public X73DimObject() {
    }

    public X73DimObject(X73DimObject mn) {
        this._object_name = mn.getBaseName();
        this._object_id = mn.getBaseRefId();
        this._object_termcode = mn.getBaseTermCode();
        this._object_reference = mn.getBaseReference();
        this._mocRefId = mn.getMocRefId();
        this._mocTermCode = mn.getMocTermCode();
        this._mocLabel = mn.getMocLabel();
        this._moc_support = mn.getMocServicesSupported();
        this._moc_comment = mn.getMocComment();
        this._moc_restrictions = mn.getMocRestrictions();
        this.status = mn.getStatus();
        this.vAttribute = new Vector();
        for (X73Attribute attr : mn.vAttribute) {
            this.vAttribute.add(attr.clone());
        }
        this.vBehavior = new Vector();
        for (X73Behavior behav : mn.vBehavior) {
            this.vBehavior.add(behav.clone());
        }
        this.vNotification = new Vector();
        for (X73Notification noti : mn.vNotification) {
            this.vNotification.add(noti.clone());
        }
    }

    public void addAttribute(X73Attribute attribute) {
        if (attribute != null) {
            this.vAttribute.add(attribute);
        }
    }

    public void addBehaviour(X73Behavior behaviour) {
        if (behaviour != null) {
            this.vBehavior.add(behaviour);
        }
    }

    public void addNotification(X73Notification notification) {
        if (notification != null) {
            this.vNotification.add(notification);
        }
    }

    public boolean equals(Object o) {
        boolean boolEqual = false;
        if (o != null && o instanceof X73DimObject) {
            X73DimObject dn = (X73DimObject)o;
            boolEqual = true;
            if (this._object_name.compareTo(dn.getBaseName()) != 0) {
                boolEqual = false;
            } else if (!this._mocLabel.isEmpty() && !dn.getMocLabel().isEmpty() && this._mocLabel.compareTo(dn.getMocLabel()) != 0) {
                boolEqual = false;
            }
        }
        return boolEqual;
    }

    public String getAdditionalObj() {
        return this.additionalObj;
    }

    public Vector<X73Attribute> getAttribute() {
        return this.vAttribute;
    }

    public Vector<X73Parameter> getAttributeParameter() {
        Vector<X73Parameter> vIPara = new Vector<X73Parameter>();
        for (X73Attribute att : this.vAttribute) {
            vIPara.add(att);
        }
        return vIPara;
    }

    public String getBaseName() {
        return this._object_name;
    }

    public String getBaseReference() {
        return this._object_reference;
    }

    public String getBaseRefId() {
        return this._object_id;
    }

    public String getBaseTermCode() {
        return this._object_termcode;
    }

    public Vector<X73Behavior> getBehavior() {
        return this.vBehavior;
    }

    public Vector<X73Parameter> getBehaviourParameter() {
        Vector<X73Parameter> vIPara = new Vector<X73Parameter>();
        for (X73Behavior att : this.vBehavior) {
            vIPara.add(att);
        }
        return vIPara;
    }

    public String getMocApplicationGuidance() {
        return this._moc_application_guidance;
    }

    public String getMocComment() {
        return this._moc_comment;
    }

    public String getMocLabel() {
        return this._mocLabel;
    }

    public String getMocRefId() {
        return this._mocRefId;
    }

    public String getMocRestrictions() {
        return this._moc_restrictions;
    }

    public String getMocServicesSupported() {
        return this._moc_support;
    }

    public String getMocTermCode() {
        return this._mocTermCode;
    }

    public Vector<X73Notification> getNotification() {
        return this.vNotification;
    }

    public Vector<X73Parameter> getNotificationParameter() {
        Vector<X73Parameter> vIPara = new Vector<X73Parameter>();
        for (X73Notification att : this.vNotification) {
            vIPara.add(att);
        }
        return vIPara;
    }

    public String getPrivateObj() {
        return this.privateObj;
    }

    public Integer getProfileId() {
        return this.object_profile_id;
    }

    public List<Integer> getProfileParentId() {
        return this.object_profile_parent_id;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isPrivate() {
        return this.bool_private_moc;
    }

    public void setAdditionalObj(String additionalObj) {
        this.additionalObj = additionalObj;
    }

    public void setMocApplicationGuidance(String moc_application_guidance) {
        this._moc_application_guidance = moc_application_guidance;
    }

    public void setMocComment(String moc_comment) {
        this._moc_comment = moc_comment;
    }

    public void setMocRestrictions(String moc_restrictions) {
        this._moc_restrictions = moc_restrictions;
    }

    public void setMocServicesSupported(String moc_services_supported) {
        this._moc_support = moc_services_supported;
    }

    public void setMocTermCode(String moc_termcode) {
        this._object_termcode = moc_termcode;
    }

    public void setMocTypeID(String moc_type_id) {
        this._mocRefId = moc_type_id;
    }

    public void setObject_profile_id(Integer object_profile_id) {
        this.object_profile_id = object_profile_id;
    }

    public void setObject_profile_parent_id(List<Integer> object_profile_parent_id) {
        this.object_profile_parent_id = object_profile_parent_id;
    }

    public void setObjectId(String object_id) {
        this._object_id = object_id;
    }

    public void setObjectName(String object_name) {
        this._object_name = object_name;
    }

    public void setObjectNameLabel(String object_name_label) {
        this._mocLabel = object_name_label;
    }

    public void setPrivate(boolean isPrivate) {
        this.bool_private_moc = isPrivate;
    }

    public void setPrivateObj(String privateObj) {
        this.privateObj = privateObj;
    }

    public void setReference(String moc_ref) {
        this._object_reference = moc_ref;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTypeIDTermCode(String moc_type_term_code) {
        this._mocTermCode = moc_type_term_code;
    }

    public String toString() {
        String ret = this._object_name + " ,  id: " + this.getProfileId() + " ,  parent id: " + this.getProfileParentId().toString();
        if (this._mocLabel != null && !this._mocLabel.equals("")) {
            ret = this._mocLabel + " [" + ret + "]";
        }
        return ret;
    }
}

