/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1;

import gov.nist.healthcare.dev.profile.control.file.xmlv1.DumpUtils;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.V1TreeBuilder;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73DimObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class V1XmlBuilder {
    private static Log log = LogFactory.getLog(V1XmlBuilder.class);
    protected Vector<X73DimObject> _objectVector;

    public V1XmlBuilder(InputStream xmlInputStream) {
        this.setup(xmlInputStream);
    }

    public X73DimObject getX73Object(String object_name) {
        for (X73DimObject ob : this._objectVector) {
            if (!ob.getBaseName().equalsIgnoreCase(object_name)) continue;
            return ob;
        }
        return null;
    }

    public List<X73DimObject> getX73ObjectChildren(X73DimObject ob) {
        if (ob == null) {
            return null;
        }
        ArrayList<X73DimObject> childrenList = new ArrayList<X73DimObject>();
        for (X73DimObject child : this._objectVector) {
            List<Integer> child_parent_id_list = child.getProfileParentId();
            if (!child_parent_id_list.contains(ob.getProfileId())) continue;
            childrenList.add(child);
        }
        return childrenList;
    }

    public X73DimObject getX73Root() {
        for (X73DimObject ob : this._objectVector) {
            if (ob.getProfileId() != 0) continue;
            return ob;
        }
        return null;
    }

    private void setup(InputStream xmIInputStream) {
        if (xmIInputStream != null) {
            try {
                V1TreeBuilder _structBuilder = new V1TreeBuilder();
                _structBuilder.buildStructure(xmIInputStream);
                this._objectVector = _structBuilder.getDimObjectVector();
                DefaultMutableTreeNode icsXmlTreeNode = _structBuilder.getTreeNode();
                log.info((Object)"BuildStructure Output");
                DumpUtils.printDefaultMutableTreeNode(icsXmlTreeNode, "   ");
                this.setupX73Object_Profile_ID(_structBuilder.getDimObjectVector());
                this.setupX73Object_Profile_Parent_ID(_structBuilder.getTreeNode());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setupX73Object_Profile_ID(Vector<X73DimObject> objectVector) {
        int i = 0;
        for (X73DimObject ob : objectVector) {
            ob.setObject_profile_id(i++);
        }
    }

    private void setupX73Object_Profile_Parent_ID(DefaultMutableTreeNode treeNode) {
        Integer profile_id = ((X73DimObject)treeNode.getUserObject()).getProfileId();
        this.setupX73Object_Profile_Parent_ID(treeNode, profile_id);
    }

    private void setupX73Object_Profile_Parent_ID(DefaultMutableTreeNode treeNode, Integer parent_id) {
        Integer profile_id = ((X73DimObject)treeNode.getUserObject()).getProfileId();
        if (!profile_id.equals(parent_id)) {
            ((X73DimObject)treeNode.getUserObject()).getProfileParentId().add(parent_id);
        }
        if (!treeNode.isLeaf()) {
            int count = treeNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.setupX73Object_Profile_Parent_ID((DefaultMutableTreeNode)treeNode.getChildAt(i), profile_id);
            }
        }
    }
}

