/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.rch;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class TreeNode {
    @XmlTransient
    protected List<TreeNode> children;
    @XmlTransient
    protected int level;
    @XmlTransient
    protected DeviceObject object;

    public TreeNode() {
    }

    public TreeNode(DeviceObject node) {
        this.setLevel(0);
        this.setObject(node);
    }

    public TreeNode(DeviceObject node, int level) {
        this.setLevel(level);
        this.setObject(node);
    }

    public void addChild(TreeNode child) {
        this.getChildren().add(child);
    }

    public List<TreeNode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode>();
        }
        return this.children;
    }

    public int getLevel() {
        return this.level;
    }

    public DeviceObject getObject() {
        return this.object;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setObject(DeviceObject node) {
        this.object = node;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.levelToString() + this.object + "\n");
        for (TreeNode t : this.getChildren()) {
            buf.append(t);
        }
        return buf.toString();
    }

    private String levelToString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.level; ++i) {
            buf.append("   |");
        }
        buf.append("--");
        return buf.toString();
    }
}

