/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.rch;

import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.rch.RCHObject;
import gov.nist.healthcare.deviceProfile.domain.rch.TreeNode;
import gov.nist.healthcare.deviceProfile.domain.rch.dim.MDS;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="RosettaContainmentHierarchy")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RosettaContainmentHierarchy", propOrder={"mdObject"})
public class RCHModel
implements RCHObject {
    @XmlElement(name="mds", type=MDS.class)
    List<TreeNode> mdObject;

    public RCHModel() {
    }

    public RCHModel(List<DeviceObject> mdobjects) {
        this.addChild(mdobjects);
    }

    @Override
    public void addChild(List<DeviceObject> mdobjects) {
        try {
            DeviceObject root = MDOUtils.GetRoot(mdobjects);
            for (DeviceObject obj : MDOUtils.GetChildren(mdobjects, root)) {
                if (obj.getDimRefid().indexOf("MDC_MOC_VMS_MDS_") == -1) continue;
                MDS mds = new MDS(obj);
                this.getMdObject().add(mds);
                mds.addChild(mdobjects);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<TreeNode> getMdObject() {
        if (this.mdObject == null) {
            this.mdObject = new LinkedList<TreeNode>();
        }
        return this.mdObject;
    }

    public void setMdObject(List<TreeNode> mdObject) {
        this.mdObject = mdObject;
    }
}

