/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.common;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TermcodeUtils {
    private static final Logger log = Logger.getLogger(TermcodeUtils.class.getName());

    public static Integer BlockTermCodeToCFCode(String btermcode) {
        if (TermcodeUtils.ValidateBlockTermCode(btermcode).booleanValue()) {
            String[] btc = btermcode.split("::");
            Integer first = TermcodeUtils.parseInt(btc[0]);
            if (btc.length > 1) {
                Integer second = TermcodeUtils.parseInt(btc[1]);
                first = first + second * 65536;
            }
            return first;
        }
        return null;
    }

    public static List<String> CardMatcher(String input) {
        String REGEX = "([0-9]+)|\\*";
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            matchList.add(matcher.group());
        }
        return matchList;
    }

    public static String CFCodeToBlockTermCode(String context_free_code10) {
        if (TermcodeUtils.ValidateBlockTermCode(context_free_code10).booleanValue()) {
            return context_free_code10;
        }
        Integer code10 = TermcodeUtils.parseInt(context_free_code10);
        if (code10 != null) {
            Integer part = code10 / 65536;
            Integer termcode = code10 % 65536;
            if (termcode != 0) {
                return TermcodeUtils.GetBlockTermCode(part, termcode);
            }
        }
        return "";
    }

    public static void DoDelete(File path) throws IOException {
        if (!path.exists()) {
            return;
        }
        if (path.isDirectory()) {
            for (File child : path.listFiles()) {
                TermcodeUtils.DoDelete(child);
            }
        }
        if (!path.delete()) {
            log.info("Could not delete " + path);
            throw new IOException("Could not delete " + path);
        }
    }

    public static String GetBlockTermCode(Integer block, Integer termcode) {
        if (block >= 0) {
            return block + "::" + termcode;
        }
        return termcode.toString();
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return TermcodeUtils.getField(superClass, fieldName);
        }
    }

    public static Method getMethod(Class<?> clss, String methodName, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Method method = clss.getDeclaredMethod(methodName, new Class[0]);
        return method;
    }

    public static void main(String[] agrs) throws Exception {
        DeviceObject obj = new DeviceObject();
        TermcodeUtils.setMethodInvoke(obj.getClass(), "cardinality", obj, "xxxxx");
        System.out.println(obj.getCardinality());
    }

    public static String NormCard(String input) {
        String ret = "";
        List<String> matchList = TermcodeUtils.CardMatcher(input);
        if (matchList.size() >= 2) {
            try {
                Integer first = Integer.valueOf(matchList.get(0));
                String secondTxt = matchList.get(1);
                if (secondTxt.equals("*")) {
                    return first + ".." + secondTxt;
                }
                Integer second = Integer.valueOf(secondTxt);
                if (first < second) {
                    return first + ".." + second;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String[] NormsCard(String input) {
        String[] ret = new String[]{"", ""};
        List<String> matchList = TermcodeUtils.CardMatcher(input);
        if (matchList.size() >= 2) {
            try {
                Integer first = Integer.valueOf(matchList.get(0));
                String secondTxt = matchList.get(1);
                if (secondTxt.equals("*")) {
                    ret[0] = first.toString();
                    ret[1] = secondTxt;
                    return ret;
                }
                Integer second = Integer.valueOf(secondTxt);
                if (first < second) {
                    ret[0] = first.toString();
                    ret[1] = secondTxt;
                    return ret;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Integer parseInt(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void setMethodInvoke(Class<?> clazz, String fieldName, Object invoke, String param) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, SecurityException, NoSuchMethodException {
        Field field2 = TermcodeUtils.getField(clazz, fieldName);
        field2.setAccessible(true);
        String MethodName = fieldName.substring(0, 1).toUpperCase();
        String getMethodName = "get" + MethodName + fieldName.substring(1);
        String setMethodName = "set" + MethodName + fieldName.substring(1);
        Method getMethod = clazz.getDeclaredMethod(getMethodName, new Class[0]);
        Method setMethod = clazz.getDeclaredMethod(setMethodName, field2.getType());
        setMethod.invoke(invoke, param);
    }

    public static Boolean ValidateBlockTermCode(String btermcode) {
        Integer termcode;
        Boolean ret = false;
        String[] btc = btermcode.split("::");
        if (btc.length > 1) {
            Integer block = TermcodeUtils.parseInt(btc[0]);
            Integer termcode2 = TermcodeUtils.parseInt(btc[1]);
            if (block != null && termcode2 != null) {
                return true;
            }
        } else if (btc.length == 1 && (termcode = TermcodeUtils.parseInt(btc[0])) != null) {
            return true;
        }
        return ret;
    }

    public static boolean ValidateCard(String input) {
        if (TermcodeUtils.NormCard(input).equals("")) {
            log.info(input + " false");
            return false;
        }
        return true;
    }

    public static Boolean ValidateCardUpperbound(String card, Integer upper) {
        if (!TermcodeUtils.ValidateCard(card)) {
            return false;
        }
        if (TermcodeUtils.NormsCard(card)[1].equals("*")) {
            return true;
        }
        Integer cardUpper = Integer.valueOf(TermcodeUtils.NormsCard(card)[1]);
        if (cardUpper >= Integer.valueOf(upper)) {
            return true;
        }
        return false;
    }
}

