/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.common;

import gov.nist.healthcare.dev.profile.common.ICSException;
import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import java.util.LinkedList;
import java.util.List;

public class OBX4Utils {
    public static void buildOBX4(DeviceObject parent, List<DeviceObject> children) {
        Integer i = 1;
        for (DeviceObject child : children) {
            if (parent.getObx4() == null || parent.getObx4().equals("")) {
                child.setObx4(i.toString());
            } else {
                child.setObx4(parent.getObx4() + "." + i.toString());
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public static int comparerObx4(String obx41, String obx42) {
        char[] c1 = obx41.toCharArray();
        char[] c2 = obx42.toCharArray();
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            return c1[i] - c2[i];
        }
        return 0;
    }

    public static void updateOBX4(List<DeviceObject> objects) throws ICSException {
        DeviceObject root = MDOUtils.GetRoot(objects);
        OBX4Utils.updateOBX4(root, objects);
    }

    public static void updateOBX4(DeviceObject parent, List<DeviceObject> objects) {
        OBX4Utils.updateOBX4(parent, objects, true);
    }

    public static void updateOBX4(DeviceObject parent, List<DeviceObject> objects, boolean recursive) {
        LinkedList<DeviceObject> childList = MDOUtils.GetChildren(objects, parent);
        OBX4Utils.buildOBX4(parent, childList);
        for (DeviceObject child : childList) {
            if (!recursive) continue;
            OBX4Utils.updateOBX4(child, objects);
        }
    }

    public static void updateOBX4(DeviceProfile profile) throws ICSException {
        DeviceObject root = profile.getRoot();
        OBX4Utils.updateOBX4(root, profile.getObjects());
    }

    public class OBX4 {
    }
}

