/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipFile {
    private static byte[] buf = new byte[512];
    private static final Logger log = Logger.getLogger(ZipFile.class.getName());

    public static File getFileFromZip(String zipFileName, String fileName) {
        return ZipFile.getFileFromZip(zipFileName, fileName, "");
    }

    public static File getFileFromZip(String zipFileName, String fileName, String prefix) {
        try {
            ZipEntry zipEntry;
            File file = new File(prefix + fileName);
            FileInputStream fis = new FileInputStream(zipFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zipIn = new ZipInputStream(bis);
            boolean found = false;
            while ((zipEntry = zipIn.getNextEntry()) != null && !found) {
                if (zipEntry.getName().equals(fileName)) {
                    int readedBytes;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    while ((readedBytes = zipIn.read(buf)) > 0) {
                        fileOutputStream.write(buf, 0, readedBytes);
                    }
                    fileOutputStream.close();
                    found = true;
                }
                zipIn.closeEntry();
            }
            zipIn.close();
            bis.close();
            fis.close();
            if (found) {
                return file;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public static InputStream getFileInputStreamFromZip(String zipFileName, String fileName) throws FileNotFoundException {
        return new FileInputStream(ZipFile.getFileFromZip(zipFileName, fileName, ""));
    }

    public static void updateZip(String zipFileName, List<File> fileList) {
        File fileCheck = new File(zipFileName);
        if (fileCheck.exists()) {
            boolean bDel = fileCheck.delete();
        }
        if (!fileCheck.exists()) {
            ZipFile.createNewZip(zipFileName, fileList);
        } else {
            try {
                ZipEntry zipEntry;
                ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFileName)));
                ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName + ".tmp")));
                while ((zipEntry = zipInput.getNextEntry()) != null) {
                    int readedBytes;
                    boolean fileExist = false;
                    for (File file : fileList) {
                        int readedBytes2;
                        if (!file.getName().equals(zipEntry.getName())) continue;
                        FileInputStream fileInputStream = new FileInputStream(file);
                        zipOutput.putNextEntry(new ZipEntry(file.getName()));
                        while ((readedBytes2 = fileInputStream.read(buf)) > 0) {
                            zipOutput.write(buf, 0, readedBytes2);
                        }
                        zipOutput.closeEntry();
                        fileInputStream.close();
                        fileExist = true;
                    }
                    if (fileExist) continue;
                    zipOutput.putNextEntry(new ZipEntry(zipEntry.getName()));
                    while ((readedBytes = zipInput.read(buf)) > 0) {
                        zipOutput.write(buf, 0, readedBytes);
                    }
                    zipOutput.closeEntry();
                }
                zipInput.closeEntry();
                zipOutput.close();
                zipInput.close();
                for (File file : fileList) {
                    if (!file.exists()) continue;
                    System.out.println("updateZip " + file.getName() + " delete " + file.delete());
                }
                File originFile = new File(zipFileName);
                originFile.delete();
                File tempFile = new File(zipFileName + ".tmp");
                tempFile.renameTo(originFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                File tempFile = new File(zipFileName + ".tmp");
                tempFile.delete();
            }
        }
    }

    private static void createNewZip(String zipFileName, List<File> fileList) {
        try {
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
            for (File file : fileList) {
                int readedBytes;
                FileInputStream fileInputStream = new FileInputStream(file);
                zipOut.putNextEntry(new ZipEntry(file.getName()));
                while ((readedBytes = fileInputStream.read(buf)) > 0) {
                    zipOut.write(buf, 0, readedBytes);
                }
                zipOut.closeEntry();
                fileInputStream.close();
                if (!file.exists()) continue;
                System.out.println("newZip " + file.getName() + " delete " + file.delete());
            }
            zipOut.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void unZip(String unZipfileName) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(unZipfileName)));
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                File file = new File(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                } else {
                    int readedBytes;
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    FileOutputStream fileOut = new FileOutputStream(file);
                    while ((readedBytes = zipIn.read(buf)) > 0) {
                        fileOut.write(buf, 0, readedBytes);
                    }
                    fileOut.close();
                }
                zipIn.closeEntry();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

