/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.guice.rest;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import gov.nist.healthcare.dev.profile.dao.RosettaDao;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSRosetta;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class RosettaDaoRestImpl
implements RosettaDao {
    private static final Logger log = Logger.getLogger(RosettaDaoRestImpl.class.getName());
    private final Client client;
    private final String webrss;

    @Inject
    public RosettaDaoRestImpl(@Named(value="ROSETTA_REST_ADDR") String webrss) {
        this.webrss = webrss;
        this.client = Client.create();
    }

    @Override
    public List<ICSRosetta> find(String refid) {
        WebResource rss = this.client.resource(this.webrss + "find/" + refid);
        return this.getTerms(rss);
    }

    @Override
    public List<ICSRosetta> get(String refid) {
        WebResource rss = this.client.resource(this.webrss + "get/" + refid);
        return this.getTerms(rss);
    }

    @Override
    public List<ICSRosetta> getHarmonizedTerms(String refid) {
        WebResource rss = this.client.resource(this.webrss + "harmonized/find/" + refid);
        return this.getTerms(rss);
    }

    @Override
    public List<ICSRosetta> getProposedTerms(String refid) {
        WebResource rss = this.client.resource(this.webrss + "proposed/find/" + refid);
        return this.getTerms(rss);
    }

    private List<ICSRosetta> getTerms(WebResource rss) {
        ArrayList ret = (ArrayList)rss.accept(new String[]{"application/xml"}).get((GenericType)new GenericType<List<ICSRosetta>>(){});
        if (ret == null) {
            ret = new ArrayList();
        }
        return ret;
    }
}

