/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.cache;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class LogInterceptor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Long startTime = null;
        startTime = System.nanoTime();
        System.out.println(String.format("before method[%s] at %s", methodName, startTime));
        Object ret = null;
        try {
            ret = invocation.proceed();
            if (startTime == null) return ret;
        }
        catch (Throwable throwable) {
            if (startTime == null) throw throwable;
            long endTime = System.nanoTime();
            System.out.println(String.format("after method[%s] at %s, cost(ns):%d", methodName, endTime, endTime - startTime));
            throw throwable;
        }
        long endTime = System.nanoTime();
        System.out.println(String.format("after method[%s] at %s, cost(ns):%d", methodName, endTime, endTime - startTime));
        return ret;
    }
}

