/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public class XMLCollectionReferenceMappingMarshalNodeValue
extends MappingNodeValue
implements ContainerValue {
    private XMLCollectionReferenceMapping xmlCollectionReferenceMapping;
    private XPathNode branchNode;
    private int index = -1;

    public XMLCollectionReferenceMappingMarshalNodeValue(XMLCollectionReferenceMapping xmlCollectionReferenceMapping) {
        this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
        this.branchNode = new XPathNode();
        NamespaceResolver namespaceResolver = ((XMLDescriptor)xmlCollectionReferenceMapping.getDescriptor()).getNamespaceResolver();
        Vector fkFields = xmlCollectionReferenceMapping.getFields();
        int x = 0;
        int fkFieldsSize = fkFields.size();
        while (x < fkFieldsSize) {
            XMLField fkField = (XMLField)fkFields.get(x);
            this.branchNode.addChild(fkField.getXPathFragment(), new XMLCollectionReferenceMappingFKMarshalNodeValue(xmlCollectionReferenceMapping, fkField), namespaceResolver);
            ++x;
        }
    }

    @Override
    public boolean isOwningNode(XPathFragment fragment) {
        return true;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.xmlCollectionReferenceMapping.getContainerPolicy();
    }

    @Override
    public XMLCollectionReferenceMapping getMapping() {
        return this.xmlCollectionReferenceMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.xmlCollectionReferenceMapping.getReuseContainer();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCollectionReferenceMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object iterator;
        if (this.xmlCollectionReferenceMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlCollectionReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (!cp.hasNext(iterator = cp.iteratorFor(collection))) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, false);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        if (xPathFragment != XPathFragment.SELF_FRAGMENT) {
            marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        }
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        if (xPathFragment != XPathFragment.SELF_FRAGMENT) {
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, (String)value);
                marshalRecord.closeStartGroupingElements(groupingFragment);
            } else {
                marshalRecord.closeStartGroupingElements(groupingFragment);
                marshalRecord.characters((String)value);
            }
        } else {
            int x = 0;
            int size = marshalContext.getNonAttributeChildrenSize(this.branchNode);
            while (x < size) {
                XPathNode xPathNode = (XPathNode)marshalContext.getNonAttributeChild(x, this.branchNode);
                xPathNode.marshal(marshalRecord, value, session, namespaceResolver, marshalRecord.getMarshaller(), marshalContext.getMarshalContext(x), null);
                ++x;
            }
        }
        return true;
    }

    @Override
    public boolean isMarshalNodeValue() {
        return !this.xmlCollectionReferenceMapping.usesSingleNode();
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }

    private static class XMLCollectionReferenceMappingFKMarshalNodeValue
    extends MappingNodeValue {
        private XMLCollectionReferenceMapping xmlCollectionReferenceMapping;
        private XMLField xmlField;

        public XMLCollectionReferenceMappingFKMarshalNodeValue(XMLCollectionReferenceMapping xmlCollectionReferenceMapping, XMLField xmlField) {
            this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
            this.xmlField = xmlField;
        }

        @Override
        public boolean isUnmarshalNodeValue() {
            return false;
        }

        @Override
        public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
            return this.marshalSingleValue(xPathFragment, marshalRecord, null, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }

        @Override
        public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
            Object fieldValue = this.xmlCollectionReferenceMapping.buildFieldValue(value, this.xmlField, session);
            if (fieldValue == null) {
                if (value != null) {
                    XMLField f2 = (XMLField)this.xmlCollectionReferenceMapping.getSourceToTargetKeyFieldAssociations().get(this.xmlField);
                    fieldValue = marshalRecord.getMarshaller().getXMLContext().getValueByXPath(value, f2.getXPath(), f2.getNamespaceResolver(), Object.class);
                }
                if (fieldValue == null) {
                    return false;
                }
            }
            QName schemaType = this.getSchemaType(this.xmlField, fieldValue, session);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, fieldValue, schemaType);
                marshalRecord.closeStartElement();
            } else {
                marshalRecord.closeStartElement();
                marshalRecord.characters(schemaType, fieldValue, null, false);
            }
            return true;
        }

        @Override
        public XMLCollectionReferenceMapping getMapping() {
            return this.xmlCollectionReferenceMapping;
        }
    }
}

