/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Session;

public class XMLDirectMappingNodeValue
extends MappingNodeValue
implements NullCapableValue {
    private XMLDirectMapping xmlDirectMapping;

    public XMLDirectMappingNodeValue(XMLDirectMapping xmlDirectMapping) {
        this.xmlDirectMapping = xmlDirectMapping;
    }

    @Override
    public void setXPathNode(XPathNode xPathNode) {
        super.setXPathNode(xPathNode);
        this.xmlDirectMapping.getNullPolicy().xPathNode(xPathNode, this);
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.isAttribute() || xPathFragment.nameIsText();
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlDirectMapping.isReadOnly()) {
            return false;
        }
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlDirectMapping);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        XPathFragment fragment;
        Object fieldValue = this.xmlDirectMapping.getFieldValue(objectValue, session, marshalRecord);
        if (fieldValue == null) {
            return this.xmlDirectMapping.getNullPolicy().directMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        QName schemaType = this.getSchemaType((XMLField)this.xmlDirectMapping.getField(), fieldValue, session);
        XPathFragment groupingFragment = null;
        boolean isQName = false;
        if (XMLConstants.QNAME_QNAME.equals(schemaType)) {
            groupingFragment = this.openGroupingElementsForQName((QName)fieldValue, marshalRecord);
            isQName = true;
        }
        if (groupingFragment == null) {
            groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        }
        if (xPathFragment.isAttribute()) {
            marshalRecord.attribute(xPathFragment, namespaceResolver, fieldValue, schemaType);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            marshalRecord.closeStartGroupingElements(groupingFragment);
            marshalRecord.characters(schemaType, fieldValue, null, this.xmlDirectMapping.isCDATA());
        }
        if (isQName && (fragment = this.getLastGroupingFragment()) != groupingFragment) {
            marshalRecord.endElement(groupingFragment, namespaceResolver);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private XPathFragment getLastGroupingFragment() {
        fragment = ((XMLField)this.getMapping().getField()).getXPathFragment();
        if (!fragment.isAttribute() && !fragment.nameIsText()) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (fragment.getNextFragment().nameIsText() || fragment.getNextFragment().isAttribute()) {
                return fragment;
            }
            fragment = fragment.getNextFragment();
lbl7:
            // 2 sources

            ** while (fragment.getNextFragment() != null)
        }
lbl8:
        // 1 sources

        return fragment;
    }

    private XPathFragment openGroupingElementsForQName(QName fieldValue, MarshalRecord marshalRecord) {
        XPathFragment xPathFragment = null;
        ArrayList<XPathNode> groupingElements = marshalRecord.getGroupingElements();
        NamespaceResolver namespaceResolver = marshalRecord.getNamespaceResolver();
        if ((fieldValue.getNamespaceURI() == null || fieldValue.getNamespaceURI().equals("")) && marshalRecord.getNamespaceResolver().getDefaultNamespaceURI() != null) {
            int x = 0;
            int groupingElementsSize = groupingElements.size();
            while (x < groupingElementsSize) {
                XPathNode xPathNode = groupingElements.get(x);
                xPathFragment = xPathNode.getXPathFragment();
                if (x == groupingElements.size() - 1 && namespaceResolver.getDefaultNamespaceURI().equals(xPathFragment.getNamespaceURI()) && xPathFragment.getPrefix() == null) {
                    String prefix = namespaceResolver.generatePrefix();
                    String xPath = String.valueOf(prefix) + ":" + xPathFragment.getShortName();
                    XPathFragment newFragment = new XPathFragment(xPath);
                    newFragment.setNamespaceURI(namespaceResolver.getDefaultNamespaceURI());
                    marshalRecord.openStartElement(newFragment, namespaceResolver);
                    marshalRecord.namespaceDeclaration(prefix, namespaceResolver.getDefaultNamespaceURI());
                    marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                    xPathFragment = newFragment;
                } else {
                    marshalRecord.openStartElement(xPathFragment, namespaceResolver);
                    marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                    marshalRecord.closeStartElement();
                }
                ++x;
            }
            marshalRecord.setGroupingElement(null);
        }
        return xPathFragment;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        unmarshalRecord.removeNullCapableValue(this);
        XMLField xmlField = (XMLField)this.xmlDirectMapping.getField();
        Object realValue = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(xmlField, value, (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager(), unmarshalRecord);
        Object convertedValue = this.xmlDirectMapping.getAttributeValue(realValue, unmarshalRecord.getSession(), unmarshalRecord);
        this.xmlDirectMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), convertedValue);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.removeNullCapableValue(this);
        XMLField xmlField = (XMLField)this.xmlDirectMapping.getField();
        if (!xmlField.getLastXPathFragment().nameIsText()) {
            return;
        }
        Object value = unmarshalRecord.getCharacters().length() == 0 ? this.getMapping().getNullValue() : unmarshalRecord.getCharacters().toString();
        unmarshalRecord.resetStringBuffer();
        XMLConversionManager xmlConversionManager = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = xmlField.getJavaClass(unmarshalRecord.getTypeQName());
            value = xmlConversionManager.convertObject(value, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(xmlField, value, xmlConversionManager, unmarshalRecord);
        }
        Object convertedValue = this.xmlDirectMapping.getAttributeValue(value, unmarshalRecord.getSession(), unmarshalRecord);
        unmarshalRecord.setAttributeValue(convertedValue, this.xmlDirectMapping);
    }

    @Override
    public void setNullValue(Object object, Session session) {
        Object value = this.xmlDirectMapping.getObjectValue(null, session);
        this.xmlDirectMapping.setAttributeValueInObject(object, value);
    }

    @Override
    public boolean isNullCapableValue() {
        if (this.xmlDirectMapping.getAttributeAccessor().isInstanceVariableAttributeAccessor() && !this.xmlDirectMapping.hasConverter() && this.xmlDirectMapping.getNullValue() == null) {
            return false;
        }
        return this.xmlDirectMapping.getNullPolicy().getIsSetPerformedForAbsentNode();
    }

    @Override
    public XMLDirectMapping getMapping() {
        return this.xmlDirectMapping;
    }

    @Override
    public boolean isWhitespaceAware() {
        return !this.xmlDirectMapping.getNullPolicy().isNullRepresentedByEmptyNode();
    }
}

