/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view.box;

import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.EntiCardinality;
import gov.nist.healthcare.mdc.applib.box.table.TableBox;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class DimCardinalityBox
extends TableBox
implements TableModelListener {
    private static final Logger log = Logger.getLogger(DimCardinalityBox.class.getName());
    protected ICSAppControl icsapp = ICSAppControl.GetInstance();

    public DimCardinalityBox() {
        super("DIM Cardinality", 22);
        this.tablePane.getTable().setDefaultRenderer(Object.class, new CardBoxTableCellRenderer());
    }

    @Override
    public void refresh() {
        if (this.icsapp.getCurrentMDObject() != null) {
            AbstractTableModel tableModel = this.getDefaultTableModel();
            tableModel.addTableModelListener(this);
            this.setModel(tableModel);
            List ids = this.icsapp.getBuilder().getInvalidCardObjectList();
            for (Integer id : ids) {
                log.info("invalid card object id " + id + "  " + this.icsapp.getProfile().getObjectById(id));
            }
        }
        super.refresh();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = (TableModel)e.getSource();
        String columnName = model.getColumnName(column);
        Object data = model.getValueAt(row, column);
        Object dataName = model.getValueAt(row, column - 1);
        log.info(columnName + " " + row + " " + column + " " + dataName + " " + data.toString());
        int index = dataName.toString().indexOf(" --- ");
        if (index != -1) {
            String parent = dataName.toString().substring(0, index);
            String child = dataName.toString().substring(index + " --- ".length());
            this.setupObCard(this.icsapp.getCurrentMDObject(), parent, child, data.toString());
        }
    }

    private AbstractTableModel getDefaultTableModel() {
        Object[] rowData;
        String cardTxt;
        DimObject parent;
        DimObject child;
        CardBoxTableModel tableModel = new CardBoxTableModel();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        List lecl = this.icsapp.getCurrentMDObject().getDimObject().getCardinalities();
        DimObject dimObj = this.icsapp.getBuilder().fetchDimObjectFromDB(this.icsapp.getCurrentMDObject());
        log.info("Size " + dimObj.getCardinalities().size());
        for (EntiCardinality card1 : lecl) {
            log.info(card1.toString());
            if (dimObj.getCardinalities().contains(card1)) {
                dimObj.getCardinalities().remove(card1);
                child = card1.getChildObject();
                parent = card1.getParentObject();
                cardTxt = card1.getCardinality();
                rowData = new Object[]{new String(parent + " --- " + child), cardTxt};
                log.info(rowData[0].toString() + rowData[1].toString());
                dataList.add(rowData);
                continue;
            }
            log.info("!contain");
        }
        for (EntiCardinality card : dimObj.getCardinalities()) {
            child = card.getChildObject();
            parent = card.getParentObject();
            cardTxt = card.getCardinality();
            rowData = new Object[]{new String(parent + " --- " + child), cardTxt};
            dataList.add(rowData);
        }
        Object[][] data = new Object[dataList.size()][2];
        int i = 0;
        for (Object[] obj : dataList) {
            log.info(obj[0].toString() + obj[1].toString());
            data[i++] = obj;
        }
        tableModel.setData(data);
        return tableModel;
    }

    private void setupObCard(DeviceObject mdo, String parent, String child, String card) {
        log.info(parent + "  " + child + "  " + card);
        EntiCardinality card1 = null;
        for (EntiCardinality encard : mdo.getDimObject().getCardinalities()) {
            if (!encard.getParentObject().getName().equals(parent) || !encard.getChildObject().getName().equals(child)) continue;
            card1 = encard;
        }
        boolean found = false;
        if (card1 == null) {
            DimObject dimObj = this.icsapp.getBuilder().fetchDimObjectFromDB(this.icsapp.getCurrentMDObject());
            for (EntiCardinality encard : dimObj.getCardinalities()) {
                if (!encard.getParentObject().getName().equals(parent) || !encard.getChildObject().getName().equals(child)) continue;
                card1 = encard;
            }
        } else {
            found = true;
        }
        if (card1 == null) {
            return;
        }
        if (!found) {
            try {
                EntiCardinality cardtmp = (EntiCardinality)card1.clone();
                cardtmp.setCardinality(card);
                mdo.getDimObject().getCardinalities().add(cardtmp);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            card1.setCardinality(card);
        }
    }

    private class CardBoxTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Objects", "Cardinality"};
        private Object[][] data;

        private CardBoxTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public Object[][] getData() {
            return this.data;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                return this.data[row][col];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setData(Object[][] data) {
            this.data = data;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    private class CardBoxTableCellRenderer
    extends DefaultTableCellRenderer {
        private CardBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(Color.BLACK);
            if (column == 1) {
                Object valueAt = table.getModel().getValueAt(row, column);
                String card = "";
                if (valueAt != null) {
                    card = valueAt.toString();
                }
                if (TermcodeUtils.ValidateCard((String)card)) {
                    String normCard = TermcodeUtils.NormCard((String)card);
                    if (!normCard.equals(card)) {
                        table.getModel().setValueAt(TermcodeUtils.NormCard((String)card), row, column);
                    }
                } else {
                    this.setForeground(Color.RED);
                }
            }
            return cell;
        }
    }
}

