/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control.conformance;

import gov.nist.healthcare.dev.profile.common.ResourceManager;
import gov.nist.healthcare.dev.profile.common.XmlXsltTool;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import gov.nist.healthcare.mdc.icsgenerator.control.conformance.ConformanceModule;
import gov.nist.healthcare.mdc.icsgenerator.control.conformance.ConformanceModuleModel;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class PCDConformance
extends ConformanceModule {
    protected ConformanceModuleModel conformanceModel;
    protected XmlXsltTool xmlXsltTool = new XmlXsltTool();
    private Document doc;

    public PCDConformance(ConformanceModuleModel model) {
        this.conformanceModel = model;
    }

    @Override
    public void createGUI() {
    }

    @Override
    public Document getDom() {
        return this.doc;
    }

    @Override
    public String getName() {
        return this.conformanceModel.getTitle();
    }

    @Override
    public JComponent getView() {
        return null;
    }

    @Override
    public void refresh() {
        if (this.conformanceModel.getXmlFilePath().equals("")) {
            this.updateDom(this.conformanceModel);
        } else {
            String xmlFilePath = this.conformanceModel.getXmlFilePath();
            xmlFilePath = xmlFilePath.substring(1, xmlFilePath.length() - 1);
            xmlFilePath = ResourceManager.newInstance((String)"resources/common/files-conf").getBundleTxt(xmlFilePath);
            this.setDom(this.xmlXsltTool.xmlInputStreamToDom(ResourceManager.newInstance().getInputStream(xmlFilePath)));
        }
    }

    public void setDom(Document dom) {
        this.doc = dom;
    }

    protected Document updateDom(ConformanceModuleModel model) {
        try {
            Document updatedom = xmlGenerator.generateXML(ICSAppControl.GetInstance().getProfile().getObjects());
            DOMSource source = new DOMSource(updatedom);
            Document updatedoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            DOMResult result = new DOMResult(updatedoc);
            TransformerFactory factory = TransformerFactory.newInstance();
            String xsltFilePath = model.getXsltFilePath();
            xsltFilePath = xsltFilePath.substring(1, xsltFilePath.length() - 1);
            xsltFilePath = ResourceManager.newInstance((String)"resources/common/files-conf").getBundleTxt(xsltFilePath);
            StreamSource styleSource = new StreamSource(ResourceManager.newInstance().getInputStream(xsltFilePath));
            Transformer transformer = factory.newTransformer(styleSource);
            transformer.transform(source, result);
            this.setDom(updatedoc);
            return updatedoc;
        }
        catch (Exception e) {
            return null;
        }
    }
}

