/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control;

import gov.nist.healthcare.dev.profile.control.app.ModelPropertyController;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.DimCommonObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.mdc.applib.beanbinding.BindingManager;
import gov.nist.healthcare.mdc.applib.beanbinding.BindingManagerImpl;
import gov.nist.healthcare.mdc.framework.Application;
import gov.nist.healthcare.mdc.framework.module.ModuleImpl;
import gov.nist.healthcare.mdc.framework.module.ViewModule;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import gov.nist.healthcare.mdc.icsgenerator.control.view.TermTreeCellRenderer;
import gov.nist.healthcare.mdc.icsgenerator.model.ICSTreeObject;
import gov.nist.healthcare.mdc.icsgenerator.view.BuildProfileView;
import gov.nist.healthcare.mdc.icsgenerator.view.RightSidePanelView;
import gov.nist.healthcare.mdc.icsgenerator.view.tree.TreePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BuildProfileModule
extends ModuleImpl
implements ViewModule,
PropertyChangeListener,
TreeSelectionListener,
ActionListener {
    private static final Logger log = Logger.getLogger(BuildProfileModule.class.getName());
    protected BuildProfileView buildProfileView;
    protected ICSTreeObject current_selected_treeobject;
    protected RightSidePanelView rightsidePanelView;
    protected DefaultMutableTreeNode selectedNode;
    protected TreePanel treePanel;

    public static void loadExpansionState(JTree loadExpTree, Enumeration<TreePath> loadExpEnum) {
        if (loadExpEnum != null) {
            while (loadExpEnum.hasMoreElements()) {
                TreePath treePath = loadExpEnum.nextElement();
                loadExpTree.expandPath(treePath);
            }
        }
    }

    public static Enumeration<TreePath> saveExpansionState(JTree saveExpTree) {
        return saveExpTree.getExpandedDescendants(new TreePath(saveExpTree.getModel().getRoot()));
    }

    public BuildProfileModule() {
        super("Builder");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Enumeration<TreePath> expenum = BuildProfileModule.saveExpansionState(this.treePanel.getTree());
        TreePath path = this.treePanel.getTree().getSelectionPath();
        if (evt.getSource() == this.treePanel.menuMouseRemove || evt.getSource() == this.treePanel.treeToolbar.removeButton) {
            path = path.getParentPath();
            this.removeDimObject(this.current_selected_treeobject);
        }
        for (JMenuItem jm : this.treePanel.menuItemList) {
            if (evt.getSource() != jm) continue;
            this.addNewObject(jm.getText());
        }
        BuildProfileModule.loadExpansionState(this.treePanel.getTree(), expenum);
        this.treePanel.getTree().setSelectionPath(path);
    }

    @Override
    public void createGUI() {
        this.treePanel = new TreePanel(this, this, new TermTreeCellRenderer());
        this.rightsidePanelView = new RightSidePanelView();
        this.buildProfileView = new BuildProfileView(this.treePanel, this.rightsidePanelView.getView());
    }

    @Override
    public JComponent getView() {
        return this.buildProfileView.getView();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        Enumeration<TreePath> expenum = BuildProfileModule.saveExpansionState(this.treePanel.getTree());
        TreePath path = this.treePanel.getTree().getSelectionPath();
        this.rightsidePanelView.refresh();
        this.treeUpdateAndRepaint();
        BuildProfileModule.loadExpansionState(this.treePanel.getTree(), expenum);
        if (path != null) {
            this.treePanel.getTree().addSelectionPath(path);
        }
    }

    @Override
    public void reset() {
        this.rightsidePanelView.showPanel("Blank");
        TreeModel model = this.getTreeModel();
        this.treePanel.setModel(model);
    }

    public void treeUpdateAndRepaint() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildProfileModule.this.treePanel.getTree().updateUI();
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (evt.getNewLeadSelectionPath() == null || evt.getNewLeadSelectionPath().equals(evt.getOldLeadSelectionPath())) {
            return;
        }
        this.selectedNode = (DefaultMutableTreeNode)((JTree)evt.getSource()).getLastSelectedPathComponent();
        String panelName = "Element";
        if (this.selectedNode != null) {
            Object nodeInfo = this.selectedNode.getUserObject();
            if (nodeInfo instanceof ICSTreeObject) {
                this.current_selected_treeobject = (ICSTreeObject)nodeInfo;
                this.setupObject();
                DeviceObject mdo = this.current_selected_treeobject.getMDObject();
                List dimObjlist = ICSAppControl.GetInstance().getBuilder().getDbController().getDimDao().getObjectChildren(mdo.getDimObject());
                ArrayList<String> childNameList = new ArrayList<String>();
                for (DimCommonObject obj : dimObjlist) {
                    childNameList.add(obj.getName());
                }
                Collections.sort(childNameList);
                this.treePanel.buildAddMenu(childNameList);
                this.rightsidePanelView.reset();
                this.rightsidePanelView.refresh();
                if (mdo.getId() == 0) {
                    panelName = "Overview";
                }
            } else {
                log.warning("selectedNode  != ICSTreeObject");
            }
        }
        this.rightsidePanelView.showPanel(panelName);
    }

    private void addNewObject(String txt) {
        log.info("Add Object " + txt);
        DeviceObject obj = ICSAppControl.GetInstance().getBuilder().addNewObject(this.current_selected_treeobject.getMDObject(), (DimCommonObject)new DimObject(txt));
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.getTree().getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
        newNode.setUserObject(new ICSTreeObject(obj));
        selectedNode.add(newNode);
        Object[] nodes = ((DefaultTreeModel)this.getTree().getModel()).getPathToRoot(newNode);
        TreePath path = new TreePath(nodes);
        this.getTree().scrollPathToVisible(path);
        this.getTree().updateUI();
        Application.getInstance().getLifecyle().refresh();
    }

    private void buildTreeModel(DefaultMutableTreeNode treeNode) {
        ICSTreeObject parent = (ICSTreeObject)treeNode.getUserObject();
        DeviceObject mdObject = parent.getMDObject();
        Integer parentId = ((ICSTreeObject)treeNode.getUserObject()).getObjectId();
        for (DeviceObject obj : ICSAppControl.GetInstance().getProfile().getObjects()) {
            if (!obj.getParentId().equals(parentId)) continue;
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(new ICSTreeObject(obj));
            treeNode.add(newChild);
            this.buildTreeModel(newChild);
        }
    }

    private JTree getTree() {
        return this.treePanel.getTree();
    }

    private TreeModel getTreeModel() {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();
        DefaultTreeModel model = null;
        for (DeviceObject obj : ICSAppControl.GetInstance().getProfile().getObjects()) {
            if (obj.getId() != 0) continue;
            treeNode.setUserObject(new ICSTreeObject(obj));
            this.buildTreeModel(treeNode);
            model = new DefaultTreeModel(treeNode);
        }
        return model;
    }

    private void removeDimObject(ICSTreeObject dimObject) {
        ICSAppControl.GetInstance().getProfile().removeObject(dimObject.getMDObject());
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.getTree().getLastSelectedPathComponent();
        if (selectedNode != null && selectedNode.getParent() != null) {
            ((DefaultTreeModel)this.getTree().getModel()).removeNodeFromParent(selectedNode);
        }
        Application.getInstance().getLifecyle().refresh();
    }

    private void setupObject() {
        DeviceObject mdo = this.current_selected_treeobject.getMDObject();
        for (PropertyChangeListener listener : mdo.getPropertyChangeSupport().getPropertyChangeListeners()) {
            mdo.getPropertyChangeSupport().removePropertyChangeListener(listener);
        }
        ModelPropertyController mpc = ICSAppControl.GetInstance().getModelPropertyController();
        mdo.getPropertyChangeSupport().addPropertyChangeListener(this);
        mpc.setObject(mdo);
        log.info(mdo.dump());
        BindingManager instance = BindingManagerImpl.getInstance();
        instance.updateBindingObject(DeviceObject.class, mdo);
        instance.updateBindingObject(DimObject.class, mdo.getDimObject());
        this.setContext("current.selected.object", this.current_selected_treeobject);
        this.setContext("current.selected.object.mdo", mdo);
        this.setContext("current.selected.object.mdo.dimo", mdo.getDimObject());
    }
}

