/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.rch.dim;

import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.rch.RCHObject;
import gov.nist.healthcare.deviceProfile.domain.rch.TreeNode;
import gov.nist.healthcare.deviceProfile.domain.rch.dim.VMD;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="mds")
public class MDS
extends TreeNode
implements RCHObject {
    public static final int DEFAULT_LEVEL = 0;
    public static final String REFID = "MDC_MOC_VMS_MDS_";
    @XmlAttribute(name="dim_refid")
    public String dim;
    @XmlAttribute(name="dim_name")
    public String dimName;
    @XmlAttribute(name="refid")
    public String refid;
    @XmlElement(name="vmd", type=VMD.class)
    List<TreeNode> mdObject;

    public MDS() {
    }

    public MDS(DeviceObject node) {
        super(node, 0);
        this.refid = node.getRefid();
        this.dim = node.getDimRefid();
        this.dimName = node.getDimName();
        this.mdObject = super.getChildren();
    }

    @Override
    public void addChild(List<DeviceObject> objects) {
        for (DeviceObject obj : MDOUtils.GetChildren(objects, this.object)) {
            if (obj.getDimRefid().indexOf("MDC_MOC_VMO_VMD") == -1) continue;
            VMD child = new VMD(obj);
            super.addChild(child);
            child.addChild(objects);
        }
    }
}

