/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view.box.param;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.DimParameter;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimBehavior;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimNotification;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.mdc.applib.beanbinding.BindingManager;
import gov.nist.healthcare.mdc.applib.beanbinding.BindingManagerImpl;
import gov.nist.healthcare.mdc.applib.box.table.TableBox;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditControl;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditModel;
import gov.nist.healthcare.mdc.framework.StandaloneResourceManager;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import gov.nist.healthcare.mdc.icsgenerator.control.view.FrameController;
import gov.nist.healthcare.mdc.icsgenerator.view.box.param.ParameterTableBoxCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

public class ParameterTable
extends TableBox {
    private static final Logger log = Logger.getLogger(ParameterTable.class.getName());
    protected JButton addPrivateItemButton;
    protected ICSAppControl icsapp = ICSAppControl.GetInstance();

    public ParameterTable(String label) {
        super(label);
        this.setupToolbar();
        this.tablePane.getTable().setDefaultRenderer(String.class, new ParameterTableBoxCellRenderer());
    }

    @Override
    public void deleteButtonClicked() {
        int[] selectedRowsIndices;
        DefaultTableModel model = (DefaultTableModel)this.tablePane.getModel();
        for (int indice : selectedRowsIndices = this.tablePane.getTable().getSelectedRows()) {
            String baseName = (String)model.getValueAt(indice, 0);
            for (ListEditModel ele : this.tableRowList) {
                DimParameter obj = (DimParameter)ele.getObject();
                if (!obj.getParaMode().equals("Private")) {
                    if (!((DimParameter)ele.getObject()).getName().equalsIgnoreCase(baseName)) continue;
                    ele.setInDestList(false);
                    continue;
                }
                DeviceObject _md_object = this.icsapp.getCurrentMDObject();
                if (_md_object == null) continue;
                if (this.getName().equalsIgnoreCase("attribute")) {
                    _md_object.getDimObject().getDimAttributes().remove(obj);
                } else if (this.getName().equalsIgnoreCase("behavior")) {
                    _md_object.getDimObject().getDimBehaviors().remove(obj);
                } else if (this.getName().equalsIgnoreCase("notification")) {
                    _md_object.getDimObject().getDimNotifications().remove(obj);
                }
                ele.setInDestList(false);
            }
        }
        this.updateToMDObject();
        this.refresh();
    }

    @Override
    public void editButtonClicked() {
        ListEditControl tableListEditControl = new ListEditControl(FrameController.getFrame(), this.tableRowList, this.getName());
        tableListEditControl.showListEditView();
        this.updateToMDObject();
        this.refresh();
    }

    @Override
    public void itemClicked() {
        int row = this.tablePane.getTable().getSelectedRow();
        if (row != -1) {
            JPanel panel = new JPanel(new BorderLayout());
            String paramName = this.tablePane.getTable().getValueAt(row, 0).toString();
            BindingManager instance = BindingManagerImpl.getInstance();
            for (ListEditModel model : this.tableRowList) {
                if (!((DimParameter)model.getObject()).getName().equals(paramName)) continue;
                if (this.getName().equalsIgnoreCase("attribute")) {
                    this.setContext("current.selected.object.mdo.dimo.attribute", model.getObject());
                    instance.updateBindingObject(DimAttribute.class, model.getObject());
                    super.itemClicked();
                    continue;
                }
                if (this.getName().equalsIgnoreCase("behavior")) {
                    this.setContext("current.selected.object.mdo.dimo.behavior", model.getObject());
                    instance.updateBindingObject(DimBehavior.class, model.getObject());
                    super.itemClicked();
                    continue;
                }
                if (!this.getName().equalsIgnoreCase("notification")) continue;
                this.setContext("current.selected.object.mdo.dimo.notification", model.getObject());
                instance.updateBindingObject(DimNotification.class, model.getObject());
                super.itemClicked();
            }
        }
    }

    @Override
    public void refresh() {
        this.updateViewModel();
        this.setModel(this.getDefaultTableModel(this.tableRowList));
        super.refresh();
    }

    @Override
    public void reset() {
        this.setContext("current.selected.object.mdo.dimo.attribute", null);
        this.setContext("current.selected.object.mdo.dimo.behavior", null);
        this.setContext("current.selected.object.mdo.dimo.notification", null);
    }

    @Override
    protected void setupToolbar() {
        super.setupToolbar();
        this.addPrivateItemButton = new JButton();
        this.addPrivateItemButton.setToolTipText("Add Private " + this.getName());
        this.addPrivateItemButton.setFocusable(false);
        this.addPrivateItemButton.setForeground(new Color(138, 43, 226));
        this.addPrivateItemButton.setIcon(StandaloneResourceManager.getInstance().getImageIcon("ADDICON"));
        this.addPrivateItemButton.addActionListener(this);
    }

    private DefaultTableModel getDefaultTableModel(Vector<ListEditModel> paramVector) {
        ParamTableModel defaultTableModel = new ParamTableModel();
        defaultTableModel.addColumn(this.getName() + " Name");
        defaultTableModel.addColumn(this.getName() + " ID");
        defaultTableModel.addColumn("Term Code");
        for (ListEditModel mod : paramVector) {
            if (!mod.isInDestList().booleanValue()) continue;
            DimParameter model = (DimParameter)mod.getObject();
            Object[] rowData = new Object[]{model.getName(), model.getRefid(), model.getTermcode()};
            defaultTableModel.addRow(rowData);
        }
        return defaultTableModel;
    }

    private void updateToMDObject() {
        DeviceObject _md_object = this.icsapp.getCurrentMDObject();
        if (_md_object != null) {
            if (this.getName().equalsIgnoreCase("attribute")) {
                _md_object.getDimObject().getDimAttributes().clear();
                for (ListEditModel ele : this.tableRowList) {
                    if (!ele.isInDestList().booleanValue()) continue;
                    _md_object.getDimObject().getDimAttributes().add((DimAttribute)ele.getObject());
                }
            } else if (this.getName().equalsIgnoreCase("behavior")) {
                _md_object.getDimObject().getDimBehaviors().clear();
                for (ListEditModel ele : this.tableRowList) {
                    if (!ele.isInDestList().booleanValue()) continue;
                    _md_object.getDimObject().getDimBehaviors().add((DimBehavior)ele.getObject());
                }
            } else if (this.getName().equalsIgnoreCase("notification")) {
                _md_object.getDimObject().getDimNotifications().clear();
                for (ListEditModel ele : this.tableRowList) {
                    if (!ele.isInDestList().booleanValue()) continue;
                    _md_object.getDimObject().getDimNotifications().add((DimNotification)ele.getObject());
                }
            }
        }
        this.updateEditButtonTxt(this.tableRowList);
    }

    private DefaultTableModel updateViewModel() {
        this.tableRowList.clear();
        DeviceObject _md_object = this.icsapp.getCurrentMDObject();
        if (_md_object != null) {
            DimObject dimObj = this.icsapp.getBuilder().fetchDimObjectFromDB(_md_object);
            if (this.getName().equalsIgnoreCase("attribute")) {
                for (DimAttribute v : _md_object.getDimObject().getDimAttributes()) {
                    this.tableRowList.add(new ListEditModel<DimAttribute>(v, true));
                    if (!dimObj.getDimAttributes().contains(v)) continue;
                    dimObj.getDimAttributes().remove(v);
                }
                for (DimAttribute v : dimObj.getDimAttributes()) {
                    if (v.getParaMode().contains("Mandatory")) {
                        this.tableRowList.add(new ListEditModel<DimAttribute>(v, true));
                        _md_object.getDimObject().getDimAttributes().add(v);
                        continue;
                    }
                    this.tableRowList.add(new ListEditModel<DimAttribute>(v, false));
                }
            } else if (this.getName().equalsIgnoreCase("behavior")) {
                for (DimBehavior v : _md_object.getDimObject().getDimBehaviors()) {
                    this.tableRowList.add(new ListEditModel<DimBehavior>(v, true));
                    if (!dimObj.getDimBehaviors().contains(v)) continue;
                    dimObj.getDimBehaviors().remove(v);
                }
                for (DimBehavior v : dimObj.getDimBehaviors()) {
                    this.tableRowList.add(new ListEditModel<DimBehavior>(v, false));
                }
            } else if (this.getName().equalsIgnoreCase("notification")) {
                for (DimNotification v : _md_object.getDimObject().getDimNotifications()) {
                    this.tableRowList.add(new ListEditModel<DimNotification>(v, true));
                    if (!dimObj.getDimNotifications().contains(v)) continue;
                    dimObj.getDimNotifications().remove(v);
                }
                for (DimNotification v : dimObj.getDimNotifications()) {
                    this.tableRowList.add(new ListEditModel<DimNotification>(v, false));
                }
            }
        }
        this.updateEditButtonTxt(this.tableRowList);
        return this.getDefaultTableModel(this.tableRowList);
    }

    public class ParamTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int cols) {
            return false;
        }
    }
}

