/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view.box;

import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnit;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnitGroup;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.mdc.applib.box.table.TableBox;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditControl;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditModel;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import gov.nist.healthcare.mdc.icsgenerator.control.view.FrameController;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

public class UnitBox
extends TableBox
implements ItemListener,
PropertyChangeListener {
    private static final Logger log = Logger.getLogger(UnitBox.class.getName());
    protected ICSAppControl applicationInstance = ICSAppControl.GetInstance();
    protected Map<String, DeviceUnitGroup> groupMap = new HashMap<String, DeviceUnitGroup>();
    protected JComboBox groupSelector;
    protected ListEditControl tableListEditControl;

    public UnitBox() {
        super("Units", 7);
        this.setupToolbar();
        this.setVisible(false);
    }

    @Override
    public void deleteButtonClicked() {
        int[] selectedRowsIndices = this.tablePane.getTable().getSelectedRows();
        DefaultTableModel model = (DefaultTableModel)this.tablePane.getModel();
        for (int indice : selectedRowsIndices) {
            String uommoc = (String)model.getValueAt(indice, 1);
            for (ListEditModel ele : this.tableRowList) {
                if (!((DeviceUnit)ele.getObject()).getUOMMDC().equalsIgnoreCase(uommoc)) continue;
                ele.setInDestList(false);
            }
        }
        this.updateToModel();
        this.refresh();
    }

    @Override
    public void editButtonClicked() {
        this.tableListEditControl = new ListEditControl(FrameController.getFrame(), this.tableRowList, this.getName());
        this.tableListEditControl.showListEditView();
        this.updateToModel();
        this.refresh();
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        String item = evt.getItem().toString();
        Object selectedObj = this.groupSelector.getSelectedItem();
        String selectedItem = "";
        if (selectedObj != null) {
            selectedItem = selectedObj.toString();
        }
        if (item.equals(selectedItem)) {
            System.out.println("itemStateChanged " + item + "   " + selectedItem);
            this.clearTableRow();
            DeviceObject currObj = this.applicationInstance.getCurrentMDObject();
            if (currObj != null) {
                currObj.getUnitGroups().clear();
            }
            DeviceUnitGroup grp = null;
            grp = item.startsWith("Saved") ? this.groupMap.get("Saved") : this.groupMap.get(item);
            if (grp != null) {
                this.setupTableRow(grp.getUnits());
                if (currObj != null) {
                    currObj.getUnitGroups().add(0, grp);
                    log.info("Size " + currObj.getEnumGroups().size());
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        log.info("UnitBox " + evt.getPropertyName());
        if (evt.getPropertyName().equals("refid")) {
            this.initUI();
            this.setupGroup();
            log.info("UnitBox property change");
        }
    }

    @Override
    public void refresh() {
        DeviceObject mdo = this.applicationInstance.getCurrentMDObject();
        if (mdo != null) {
            String dim_refid = mdo.getDimRefid().toUpperCase();
            if (dim_refid.equals("MDC_MOC_VMO_METRIC_NU")) {
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }
        this.setupGroup();
        super.refresh();
    }

    @Override
    public void reset() {
        this.setVisible(false);
        this.initUI();
    }

    @Override
    protected DefaultTableModel getDefaultTableModel(List<ListEditModel> modelList) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("DIM");
        defaultTableModel.addColumn("UOM_MDC");
        defaultTableModel.addColumn("UOM_UCUM");
        defaultTableModel.addColumn("Term Code");
        for (ListEditModel _unit : modelList) {
            if (!_unit.isInDestList().booleanValue()) continue;
            DeviceUnit unit = (DeviceUnit)_unit.getObject();
            try {
                Object[] rowData = new Object[]{unit.getDIM(), unit.getUOMMDC(), unit.getUOMUCUM(), TermcodeUtils.CFCodeToBlockTermCode((String)unit.getCFUCODE10())};
                defaultTableModel.addRow(rowData);
            }
            catch (Exception e) {}
        }
        return defaultTableModel;
    }

    @Override
    protected void setupToolbar() {
        this.groupSelector = new JComboBox();
        JPanel optionPanelToolBar = new JPanel();
        optionPanelToolBar.setLayout(new BoxLayout(optionPanelToolBar, 2));
        optionPanelToolBar.add(this.groupSelector);
        this.setHeadComponent(optionPanelToolBar);
    }

    private DimAttribute getAttribute(String name, List<DimAttribute> attrs) {
        for (DimAttribute att : attrs) {
            if (!att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    private void initUI() {
        this.clearTableRow();
        this.groupSelector.removeItemListener(this);
        this.groupSelector.removeAllItems();
        this.groupMap = new HashMap<String, DeviceUnitGroup>();
    }

    private void setupGroup() {
        this.setupGroupMap();
        this.groupSelector.removeItemListener(this);
        this.groupSelector.addItem("");
        for (Map.Entry<String, DeviceUnitGroup> e : this.groupMap.entrySet()) {
            String key = e.getKey();
            DeviceUnitGroup grp = e.getValue();
            if (grp == null) continue;
            if (key.equals("Saved")) {
                this.groupSelector.addItem("Saved " + grp.getUnitGroup());
                this.groupSelector.setSelectedItem("Saved " + grp.getUnitGroup());
                this.setupTableRow(grp.getUnits());
                continue;
            }
            this.groupSelector.addItem(key);
        }
        this.groupSelector.addItemListener(this);
    }

    private void setupGroupMap() {
        DeviceObject currObj = this.applicationInstance.getCurrentMDObject();
        DeviceObject tmp = null;
        if (currObj != null) {
            log.info("Size " + currObj.getUnitGroups().size());
            if (currObj.getUnitGroups().size() > 0) {
                this.groupMap.put("Saved", (DeviceUnitGroup)currObj.getUnitGroups().get(0));
            }
            tmp = this.applicationInstance.getBuilder().updateUnitEnum(currObj.getRefid());
        }
        if (tmp != null) {
            for (DeviceUnitGroup grp : tmp.getUnitGroups()) {
                this.groupMap.put(grp.getUnitGroup(), grp);
            }
        }
        this.groupMap.put("", null);
    }

    private void updateAttrUnitCode() {
        DimObject dimObj;
        DimAttribute att;
        DeviceObject _md_object = this.applicationInstance.getCurrentMDObject();
        if (_md_object != null && _md_object.getUnit().size() > 0 && (att = this.getAttribute("Unit-Code", (dimObj = this.applicationInstance.getBuilder().fetchDimObjectFromDB(_md_object)).getDimAttributes())) != null) {
            StringBuffer buf = new StringBuffer("");
            for (DeviceUnit unit : _md_object.getUnit()) {
                buf.append(unit.getCFUCODE10() + ",");
            }
            if (!_md_object.getDimObject().getDimAttributes().contains(att)) {
                att.setValidValues(buf.toString());
                _md_object.getDimObject().getDimAttributes().add(att);
            } else {
                int index = _md_object.getDimObject().getDimAttributes().indexOf(att);
                DimAttribute obj = (DimAttribute)_md_object.getDimObject().getDimAttributes().get(index);
                obj.setValidValues(buf.toString());
            }
        }
    }

    private void updateToModel() {
        DeviceObject _md_object = this.applicationInstance.getCurrentMDObject();
        if (_md_object != null) {
            _md_object.getUnit().clear();
            for (ListEditModel ele : this.tableRowList) {
                if (!ele.isInDestList().booleanValue()) continue;
                _md_object.getUnit().add((DeviceUnit)ele.getObject());
            }
            this.updateAttrUnitCode();
        }
        this.updateEditButtonTxt(this.tableRowList);
    }
}

