/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control.view;

import gov.nist.healthcare.mdc.applib.SwingFrame;
import gov.nist.healthcare.mdc.framework.module.ModuleContainer;
import gov.nist.healthcare.mdc.framework.module.ViewModule;
import gov.nist.healthcare.mdc.framework.mvc.AbsController;
import gov.nist.healthcare.mdc.icsgenerator.control.BuildProfileModule;
import gov.nist.healthcare.mdc.icsgenerator.control.view.FrameController;
import gov.nist.healthcare.mdc.icsgenerator.control.view.ICSModuleContainer;
import gov.nist.healthcare.mdc.icsgenerator.view.ToolBar;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ICSViewController
extends AbsController {
    private static final Logger log = Logger.getLogger(ICSViewController.class.getName());
    public static final ICSViewController instance = new ICSViewController();
    protected CardLayout cardLayout;
    protected JPanel contentPanel;
    protected FrameController frameController;
    protected ToolBar toolBar;
    private final BuildProfileModule buildViewControl;
    private ModuleContainer moduleContainer = ICSModuleContainer.getModuleContainer();

    public static ICSViewController getInstance() {
        return instance;
    }

    public ICSViewController() {
        this.buildViewControl = new BuildProfileModule();
        this.moduleContainer.getModuleList().addFirst(this.buildViewControl);
    }

    public JFrame getFrame() {
        this.getFrameView();
        return FrameController.getFrame();
    }

    public FrameController getFrameView() {
        if (this.frameController == null) {
            this.frameController = new FrameController();
        }
        return this.frameController;
    }

    public List<ViewModule> getModuleList() {
        return this.moduleContainer.getModuleList();
    }

    @Override
    public void initialize() {
        for (ViewModule vc : this.getModuleList()) {
            vc.initialize();
        }
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)new JPanel(), "Blank");
        this.cardLayout = (CardLayout)this.contentPanel.getLayout();
        this.cardLayout.show(this.contentPanel, "Blank");
        for (ViewModule vc : this.getModuleList()) {
            this.contentPanel.add((Component)vc.getView(), vc.getName());
        }
        if (this.getModuleList().size() > 0) {
            this.cardLayout.show(this.contentPanel, this.getModuleList().get(0).getName());
        }
        this.frameController = this.getFrameView();
        ((SwingFrame)this.frameController.getView()).setComponent(this.contentPanel);
        this.toolBar = new ToolBar();
        this.toolBar.setViewControlList(this.getModuleList());
        this.showView(this.getModuleList().get(0).getName());
        ((SwingFrame)this.frameController.getView()).setToolBar(this.toolBar);
        this.frameController.initialize();
    }

    @Override
    public synchronized void refresh() {
        this.moduleContainer.refresh();
        this.frameController.refresh();
    }

    @Override
    public void reset() {
        for (ViewModule vc : this.getModuleList()) {
            vc.reset();
        }
        this.frameController.reset();
    }

    public void showView(String viewName) {
        this.cardLayout.show(this.contentPanel, viewName);
        this.toolBar.reset(viewName);
    }
}

