/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control;

import com.google.inject.Guice;
import com.google.inject.Module;
import gov.nist.healthcare.dev.profile.control.DPControl;
import gov.nist.healthcare.dev.profile.control.app.ModelPropertyController;
import gov.nist.healthcare.dev.profile.control.config.RestConfig;
import gov.nist.healthcare.dev.profile.control.core.BuilderController;
import gov.nist.healthcare.dev.profile.control.dao.ICSGeneratorDaoModule;
import gov.nist.healthcare.dev.profile.control.file.ProjectFileController;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.LoadExample;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.ModelAdaptor;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.V1XmlBuilder;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73DimObject;
import gov.nist.healthcare.dev.profile.dao.DBDao;
import gov.nist.healthcare.deviceProfile.domain.common.JaxbUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.ProfileResume;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.mdc.applib.beanbinding.BindingManager;
import gov.nist.healthcare.mdc.applib.beanbinding.BindingManagerImpl;
import gov.nist.healthcare.mdc.framework.AppContextResource;
import gov.nist.healthcare.mdc.icsgenerator.control.view.FrameController;
import gov.nist.healthcare.mdc.icsgenerator.control.view.ICSViewController;
import gov.nist.healthcare.mdc.icsgenerator.control.view.MenubarControl;
import gov.nist.healthcare.mdc.icsgenerator.model.AppConfiguration;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;

public class ICSAppControl
extends AppContextResource
implements DPControl {
    public static boolean Reachable = false;
    private static ICSAppControl instance;
    private static final Logger log;
    private BuilderController builder;
    private DBDao dbcontroller;
    private ModelPropertyController mpc;
    private ProjectFileController project;

    public static ICSAppControl GetInstance() {
        if (instance == null) {
            instance = new ICSAppControl();
        }
        return instance;
    }

    public ICSAppControl() {
        String server_addr = RestConfig.SERVER_ADDR;
        String app_name = RestConfig.APP_NAME;
        Reachable = this.reachable(server_addr + app_name);
        log.info("Web Service reachable " + Reachable);
        this.dbcontroller = (DBDao)Guice.createInjector((Module[])new Module[]{new ICSGeneratorDaoModule()}).getInstance(DBDao.class);
        this.project = ProjectFileController.NewProfile();
        this.builder = new BuilderController(this.dbcontroller);
        this.builder.setProfileController(this.project.getProfileController());
        this.mpc = new ModelPropertyController(this.builder);
        this.loadApplicationConfig();
        this.updateRecentMenu();
    }

    public void updateRecentMenu() {
        AppConfiguration model = (AppConfiguration)this.getContext("application.config");
        ICSViewController.getInstance().getFrameView();
        MenubarControl menuControl = FrameController.menuControl;
        if (model != null) {
            menuControl.getBar().fileMenuBar.updateRecent(model.getRecentProfiles());
        }
    }

    public boolean saveApplicationConfig() {
        AppConfiguration model = (AppConfiguration)this.getContext("application.config");
        if (model == null) {
            model = new AppConfiguration();
            model.setDefault();
            this.setContext("application.config", model);
        }
        try {
            JaxbUtils.Marshall((Object)model, (OutputStream)new FileOutputStream("config.xml"));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public AppConfiguration loadApplicationConfig() {
        try {
            AppConfiguration model = (AppConfiguration)JaxbUtils.Unmarshall(AppConfiguration.class, (InputStream)new FileInputStream("config.xml"));
            this.setContext("application.config", model);
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.saveApplicationConfig()) {
                AppConfiguration model = (AppConfiguration)this.getContext("application.config");
                return model;
            }
            return null;
        }
    }

    public DeviceProfile createProfile() {
        this.project = ProjectFileController.NewProfile();
        return this.project.getProfile();
    }

    public BuilderController getBuilder() {
        return this.builder;
    }

    public BuilderController getBuilderController() {
        return this.builder;
    }

    public DeviceObject getCurrentMDObject() {
        DeviceObject _md_object = (DeviceObject)this.getContext("current.selected.object.mdo");
        return _md_object;
    }

    public DBDao getDatabase() {
        return this.getBuilder().getDbController();
    }

    public DimObject getDimObject() {
        DeviceObject obj = this.getCurrentMDObject();
        if (obj == null) {
            return null;
        }
        DimObject dimObj = this.getDatabase().getDimDao().getObjectByReferenceId(obj.getDimRefid());
        if (dimObj != null) {
            return dimObj;
        }
        return new DimObject();
    }

    public ModelPropertyController getModelPropertyController() {
        return this.mpc;
    }

    public DeviceProfile getProfile() {
        return this.project.getProfile();
    }

    public ProjectFileController getProject() {
        return this.project;
    }

    public void loadSpec(String expName) {
        DeviceProfile profile = this.createProfile();
        LoadExample loadExp = LoadExample.getInstance();
        V1XmlBuilder xmlDB = loadExp.setupExample(profile, expName);
        this.project.config();
        this.builder.setProfileController(this.project.getProfileController());
        List objects = profile.getObjects();
        ModelAdaptor.buildDimObjectList((V1XmlBuilder)xmlDB, (List)objects, (X73DimObject)xmlDB.getX73Root());
    }

    public void newProject() {
        this.project.config();
        this.builder.setProfileController(this.project.getProfileController());
        this.builder.addRootToList();
        this.setContextProfile(this.project.getProfile());
    }

    public void openProject(String path) {
        this.project = new ProjectFileController(path);
        this.project.config();
        this.builder.setProfileController(this.project.getProfileController());
        this.builder.rebuild(this.project.getProfile());
        this.setContextProfile(this.project.getProfile());
        this.updateRecentMenu();
    }

    public void persistProject() {
        try {
            this.project.persistProject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean reachable(String strUrl) {
        boolean ret = false;
        try {
            URL url = new URL(strUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.connect();
            if (200 == urlConn.getResponseCode()) {
                ret = true;
            }
            urlConn.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    private void setContextProfile(DeviceProfile profile) {
        this.setContext("current.profile", profile);
        this.setContext("current.profile.resume", profile.getResume());
        this.updateBindingManager(profile);
    }

    private void updateBindingManager(DeviceProfile profile) {
        BindingManager instance = BindingManagerImpl.getInstance();
        instance.updateBindingObject(ProfileResume.class, profile.getResume());
    }

    static {
        log = Logger.getLogger(ICSAppControl.class.getName());
    }
}

