/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.guice.rest;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import gov.nist.healthcare.dev.profile.dao.DBDao;
import gov.nist.healthcare.dev.profile.dao.DimDao;
import gov.nist.healthcare.dev.profile.dao.NomnDao;
import gov.nist.healthcare.dev.profile.dao.RosettaDao;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceTerm;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnit;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSEnum;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSRosetta;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DBDaoRestImpl
implements DBDao {
    private static final Logger log = Logger.getLogger(DBDaoRestImpl.class.getName());
    private final Client client;
    @Inject
    private DimDao dimDao;
    @Inject
    private NomnDao nomenclatureDao;
    @Inject
    private RosettaDao rosettaDao;
    private final String webrss;

    public static DeviceUnit MDUnitFactory(ICSUnit u) {
        DeviceUnit unit = new DeviceUnit();
        unit.setCFUCODE10(u.toCFCode());
        unit.setUOMMDC(u.getRefid());
        unit.setUOMUCUM(u.getUcums());
        return unit;
    }

    public static List<DeviceUnit> MDUnitFactory(List<ICSUnit> units) {
        ArrayList<DeviceUnit> ret = new ArrayList<DeviceUnit>();
        for (ICSUnit unit : units) {
            DeviceUnit mdUnit = DBDaoRestImpl.MDUnitFactory(unit);
            if (ret.contains(mdUnit)) continue;
            ret.add(mdUnit);
        }
        return ret;
    }

    @Inject
    public DBDaoRestImpl(@Named(value="SEMANTIC_REST_ADDR") String webrss) {
        this.webrss = webrss;
        this.client = Client.create();
    }

    @Override
    public List<String> find(String keyword) {
        ArrayList<String> ret = new ArrayList<String>();
        for (DeviceTerm term : this.findTerms(keyword)) {
            ret.add(term.getRefid());
        }
        return ret;
    }

    @Override
    public List<DeviceTerm> findTerms(String keyword) {
        List ret = null;
        if (keyword != null && !keyword.equals("")) {
            WebResource webResource = this.client.resource(this.webrss + "find/" + keyword.toUpperCase());
            System.out.println(this.webrss + "find/" + keyword.toUpperCase());
            ret = (List)webResource.accept(new String[]{"application/xml"}).get((GenericType)new GenericType<List<DeviceTerm>>(){});
        }
        if (ret == null) {
            ret = new ArrayList();
        }
        return ret;
    }

    @Override
    public DimDao getDimDao() {
        return this.dimDao;
    }

    @Override
    public List<String> getEnums(List<ICSRosetta> terms) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ICSRosetta t : terms) {
            for (ICSEnum enu : t.getEnums()) {
                String token = enu.getToken();
                if (token == null) {
                    token = enu.getRefid();
                }
                if (token == null || ret.contains(token)) continue;
                ret.add(token);
            }
        }
        return ret;
    }

    @Override
    public NomnDao getNomenclatureDao() {
        return this.nomenclatureDao;
    }

    @Override
    public RosettaDao getRtmDao() {
        return this.rosettaDao;
    }

    @Override
    public List<DeviceTerm> getTerms(String keyword) {
        List ret = null;
        if (keyword != null && !keyword.equals("")) {
            WebResource webResource = this.client.resource(this.webrss + "get/" + keyword);
            ret = (List)webResource.get((GenericType)new GenericType<List<DeviceTerm>>(){});
        }
        if (ret == null) {
            ret = new ArrayList();
        }
        return ret;
    }

    @Override
    public List<DeviceUnit> getUnits(List<ICSRosetta> terms) {
        ArrayList<DeviceUnit> ret = new ArrayList<DeviceUnit>();
        for (ICSRosetta t : terms) {
            for (DeviceUnit mdUnit : DBDaoRestImpl.MDUnitFactory(t.getUnits())) {
                if (ret.contains(mdUnit)) continue;
                ret.add(mdUnit);
            }
        }
        return ret;
    }

    @Override
    public List<DeviceUnit> getUnits(DeviceTerm term) {
        ArrayList<DeviceUnit> ret = new ArrayList<DeviceUnit>();
        if (term.getDb().startsWith("Rosetta - PROPOSED")) {
            List<ICSRosetta> terms = this.getRtmDao().getProposedTerms(term.getRefid());
            ret.addAll(this.getUnits(terms));
        } else if (term.getDb().startsWith("Rosetta - HARMONIZED")) {
            List<ICSRosetta> terms = this.getRtmDao().getHarmonizedTerms(term.getRefid());
            ret.addAll(this.getUnits(terms));
        }
        return ret;
    }
}

