/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.cache;

import gov.nist.healthcare.dev.profile.dao.cache.MapKeywordSearch;
import gov.nist.healthcare.deviceProfile.domain.rtmms.nomenclature.Coded_term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TermCacheManager {
    protected MapKeywordSearch<Coded_term> keywordsearch = new MapKeywordSearch();
    protected Integer maxsize = 0;
    protected Map<String, Coded_term> termMap = new HashMap<String, Coded_term>();

    public void cacheAllTerms(Object ret) {
        if (ret instanceof List) {
            List ctList = (List)ret;
            for (Coded_term t : ctList) {
                this.termMap.put(t.getReference_id(), t);
            }
            ArrayList<String> keys = new ArrayList<String>(this.termMap.keySet());
            Collections.sort(keys);
            this.setMaxsize(this.termMap.keySet().size());
        }
    }

    public void cacheResult(String keyword, List<Coded_term> values) {
        this.keywordsearch.cache.put(keyword, values);
    }

    public List<Coded_term> checkCache(String keyword) {
        List<Coded_term> simkeyword;
        List<Coded_term> ret = this.keywordsearch.checkCache(keyword);
        if (ret == null && (simkeyword = this.keywordsearch.checkCacheSimilarKeyword(keyword)) != null) {
            ret = new LinkedList<Coded_term>();
            for (Coded_term t : simkeyword) {
                if (!t.getReference_id().contains(keyword)) continue;
                ret.add(t);
            }
            if (ret.size() < 1) {
                ret = null;
            } else {
                this.cacheResult(keyword, ret);
            }
        }
        return ret;
    }

    public Boolean containsAll() {
        if (this.termMap.keySet().size() >= this.maxsize && this.maxsize > 0) {
            return true;
        }
        return false;
    }

    public Coded_term get(String key) {
        return this.termMap.get(key);
    }

    public List<Coded_term> getAllCachedTerms() {
        LinkedList<Coded_term> ret = new LinkedList<Coded_term>();
        for (Map.Entry<String, Coded_term> m : this.termMap.entrySet()) {
            ret.add(m.getValue());
        }
        return ret;
    }

    public List<Coded_term> searchMatchTerms(String keyword) {
        return this.keywordsearch.searchMatchTerms(keyword, this.termMap);
    }

    public void setMaxsize(Integer maxsize) {
        this.maxsize = maxsize;
    }
}

