/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.cache;

import gov.nist.healthcare.dev.profile.dao.cache.TermCacheManager;
import gov.nist.healthcare.deviceProfile.domain.rtmms.nomenclature.Coded_term;
import java.util.List;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class NomnCacheInterceptor
extends TermCacheManager
implements MethodInterceptor {
    private final Logger log = Logger.getLogger(NomnCacheInterceptor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        String targetName = "getSimilarTerms";
        Long startTime = null;
        if (methodName.equals(targetName)) {
            startTime = System.nanoTime();
            System.out.println(String.format("before method[%s] at %s", methodName, startTime));
        }
        Object ret = null;
        try {
            String keyword;
            if (methodName.equals("getSimilarTerms")) {
                keyword = (String)invocation.getArguments()[0];
                ret = this.checkCache(keyword);
                if (ret == null) {
                    if (this.containsAll().booleanValue()) {
                        ret = this.searchMatchTerms(keyword);
                    } else {
                        ret = invocation.proceed();
                        List<Coded_term> dictValues = ret;
                        if (dictValues.size() > 0) {
                            this.cacheResult(keyword, dictValues);
                        }
                    }
                }
            } else if (methodName.equals("getTermsByReferenceId")) {
                keyword = (String)invocation.getArguments()[0];
                ret = this.get(keyword);
                if (ret == null) {
                    ret = invocation.proceed();
                }
            } else if (methodName.equals("getAllTerms")) {
                if (!this.containsAll().booleanValue()) {
                    this.log.info("ret null");
                    ret = invocation.proceed();
                    this.cacheAllTerms(ret);
                } else {
                    this.log.info("ret not null");
                    ret = this.getAllCachedTerms();
                }
            } else {
                ret = invocation.proceed();
            }
            if (startTime == null) return ret;
        }
        catch (Throwable throwable) {
            if (startTime == null) throw throwable;
            long endTime = System.nanoTime();
            System.out.println(String.format("after method[%s] at %s, cost(ns):%d", methodName, endTime, endTime - startTime));
            throw throwable;
        }
        long endTime = System.nanoTime();
        System.out.println(String.format("after method[%s] at %s, cost(ns):%d", methodName, endTime, endTime - startTime));
        return ret;
    }
}

