/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.device.object;

import gov.nist.healthcare.deviceProfile.domain.IMDObject;
import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceEnumGroup;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnit;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnitGroup;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"name", "dimName", "refid", "dimRefid", "code10", "description", "units", "unitGroups", "enumSet", "enumGroups", "dimParameters", "comment", "support", "obx4", "obxv", "cardinality", "group", "id", "parentId", "displayname", "dimObject"})
public class DeviceObject
implements Cloneable,
IMDObject {
    private static final Logger log = Logger.getLogger(DeviceObject.class.getName());
    @XmlElement(name="term_cardinality")
    protected String cardinality = "0...*";
    @XmlElement(name="code10")
    protected String code10;
    @XmlCDATA
    @XmlElement(name="description")
    protected String description;
    @XmlElement(name="dim_name")
    protected String dimName;
    @Deprecated
    protected DimObject dimObject;
    @XmlElementWrapper(name="dim_parameters")
    @XmlElement(name="parameter")
    protected List<DeviceObject> dimParameters;
    @XmlElement(name="dim_refid", nillable=true, required=true)
    protected String dimRefid = "";
    @Deprecated
    @XmlElement(name="display_name")
    protected String displayname;
    @XmlElementWrapper(name="enum_groups")
    @XmlElement(name="enum_group")
    protected List<DeviceEnumGroup> enumGroups;
    @XmlElementWrapper(name="enums")
    @XmlElement(name="enumValue")
    protected List<String> enumSet;
    @XmlElementWrapper(name="groups")
    @XmlElement(name="group", required=true)
    protected List<String> group;
    @XmlElement(name="obj_element_id", required=true, type=Integer.class, nillable=true)
    protected Integer id = -1;
    @XmlElement(name="name")
    protected String name;
    @XmlElement(name="OBX4")
    protected String obx4;
    @XmlElement(name="OBXV")
    protected String obxv;
    @XmlElement(name="obj_element_parentId", required=true, type=Integer.class, nillable=true)
    protected Integer parentId = -1;
    @XmlElement(name="refid", nillable=true, required=true)
    protected String refid = "";
    @XmlElementWrapper(name="unit_groups")
    @XmlElement(name="unit_group")
    protected List<DeviceUnitGroup> unitGroups;
    @XmlElementWrapper(name="units")
    @XmlElement(name="unit")
    protected List<DeviceUnit> units;
    @XmlCDATA
    @XmlElement(name="comment")
    private String comment;
    @XmlTransient
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @XmlElement(name="support")
    private String support;

    public DeviceObject() {
        this.setDimObject(new DimObject());
    }

    public DeviceObject(DimObject dimObj) {
        this.setDimObject(dimObj);
    }

    public Object clone() throws CloneNotSupportedException {
        DeviceObject cloneObj = (DeviceObject)super.clone();
        if (this.dimObject != null) {
            cloneObj.setDimObject((DimObject)this.dimObject.clone());
        }
        cloneObj.getUnit().clear();
        for (DeviceUnit unit : this.getUnit()) {
            cloneObj.getUnit().add((DeviceUnit)unit.clone());
        }
        cloneObj.getEnumSet().clear();
        for (String enumValue : this.getEnumSet()) {
            cloneObj.getEnumSet().add(new String(enumValue));
        }
        return cloneObj;
    }

    @Override
    public String dump() {
        return this.getId() + "  " + this.toString() + "   " + this.code10;
    }

    @Override
    public String getCardinality() {
        return this.cardinality;
    }

    @Override
    public String getCode10() {
        return this.code10;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDimName() {
        return this.dimName;
    }

    @Override
    @Deprecated
    public DimObject getDimObject() {
        if (this.dimObject == null) {
            this.dimObject = new DimObject();
        }
        return this.dimObject;
    }

    @Override
    public List<DeviceObject> getDimParameters() {
        if (this.dimParameters == null) {
            this.dimParameters = new ArrayList<DeviceObject>();
        }
        return this.dimParameters;
    }

    @Override
    public String getDimRefid() {
        return this.dimRefid;
    }

    @Override
    @Deprecated
    public String getDisplayname() {
        return this.displayname;
    }

    public List<DeviceEnumGroup> getEnumGroups() {
        if (this.enumGroups == null) {
            this.enumGroups = new ArrayList<DeviceEnumGroup>();
        }
        return this.enumGroups;
    }

    @Override
    public List<String> getEnumSet() {
        if (this.enumSet == null) {
            this.enumSet = new ArrayList<String>();
        }
        return this.enumSet;
    }

    @Override
    public List<String> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        return this.group;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getObx4() {
        return this.obx4;
    }

    @Override
    public String getObxv() {
        return this.obxv;
    }

    @Override
    public Integer getParentId() {
        return this.parentId;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    @Override
    public String getRefid() {
        return this.refid;
    }

    @Override
    public String getSupport() {
        return this.support;
    }

    @Override
    public List<DeviceUnit> getUnit() {
        if (this.units == null) {
            this.units = new ArrayList<DeviceUnit>();
        }
        return this.units;
    }

    public List<DeviceUnitGroup> getUnitGroups() {
        if (this.unitGroups == null) {
            this.unitGroups = new ArrayList<DeviceUnitGroup>();
        }
        return this.unitGroups;
    }

    @Override
    public void setCardinality(String cardinality) {
        String ret = TermcodeUtils.NormCard(cardinality);
        if (!ret.equals("")) {
            this.cardinality = TermcodeUtils.NormCard(cardinality);
        }
        log.info(this.cardinality + "  " + cardinality);
    }

    @Override
    public void setCode10(String code10) {
        this.code10 = code10;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setDimName(String dimName) {
        this.dimName = dimName;
    }

    @Override
    @Deprecated
    public void setDimObject(DimObject value) {
        this.dimObject = value;
        if (this.dimObject != null) {
            this.dimRefid = this.dimObject.getRefid();
            this.dimName = this.dimObject.getName();
        }
    }

    @Override
    public void setDimParameters(List<DeviceObject> dimParameters) {
        this.dimParameters = dimParameters;
    }

    @Override
    public void setDimRefid(String dimRefid) {
        this.dimRefid = dimRefid;
    }

    @Override
    @Deprecated
    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public void setEnumGroups(List<DeviceEnumGroup> enumGroups) {
        this.enumGroups = enumGroups;
    }

    @Override
    public void setEnumSet(List<String> enumSet) {
        this.enumSet = enumSet;
    }

    @Override
    public void setGroup(List<String> group) {
        this.group = group;
    }

    @Override
    public void setId(Integer value) {
        this.id = value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setObx4(String obx4) {
        this.obx4 = obx4;
    }

    @Override
    public void setObxv(String obxv) {
        this.obxv = obxv;
    }

    @Override
    public void setParentId(Integer value) {
        this.parentId = value;
    }

    @Override
    public void setRefid(String refid) {
        this.refid = refid;
    }

    @Override
    public void setSupport(String support) {
        this.support = support;
    }

    @Override
    public void setUnit(List<DeviceUnit> unit) {
        this.units = unit;
    }

    public void setUnitGroups(List<DeviceUnitGroup> unitGroups) {
        this.unitGroups = unitGroups;
    }

    public String toString() {
        String ret = "Blank Object";
        if (!this.getDimName().equals("")) {
            ret = this.getDimName();
        }
        if (this.getName() != null && !this.getName().equals("")) {
            ret = this.getName() + " [" + ret + "]";
        }
        if (this.obx4 != null) {
            return this.obx4 + " " + ret;
        }
        return ret;
    }
}

