/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.device;

import gov.nist.healthcare.dev.profile.common.ICSException;
import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.common.MDObjectComparator;
import gov.nist.healthcare.deviceProfile.domain.common.OBX4Utils;
import gov.nist.healthcare.deviceProfile.domain.device.ProfileResume;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"resume", "mdobjects"})
@XmlRootElement(name="DeviceInformationModel")
public class DeviceProfile
implements Cloneable {
    private static final Logger log = Logger.getLogger(DeviceProfile.class.getName());
    @XmlElementWrapper(name="MDObjects")
    @XmlElement(name="MDObject", required=true)
    protected List<DeviceObject> mdobjects;
    @XmlElement(name="Resume")
    protected ProfileResume resume;

    public DeviceObject addObject(DeviceObject parent, DeviceObject mdo) {
        mdo.setId(MDOUtils.IDGeneration(this.getObjects()));
        mdo.setParentId(parent.getId());
        this.getObjects().add(mdo);
        this.updateObx4();
        return mdo;
    }

    public List<DeviceObject> getChildren(DeviceObject obj) {
        return MDOUtils.GetChildren(this.getObjects(), obj);
    }

    public DeviceObject getObjectById(Integer id) {
        return MDOUtils.GetObjById(id, this.getObjects());
    }

    public List<DeviceObject> getObjects() {
        if (this.mdobjects == null) {
            this.mdobjects = Collections.synchronizedList(new LinkedList());
        }
        return this.mdobjects;
    }

    public DeviceObject getParent(DeviceObject obj) {
        return MDOUtils.GetParent(this.getObjects(), obj);
    }

    public ProfileResume getResume() {
        if (this.resume == null) {
            this.resume = new ProfileResume();
        }
        return this.resume;
    }

    public DeviceObject getRoot() {
        try {
            return MDOUtils.GetRoot(this.getObjects());
        }
        catch (ICSException e) {
            return null;
        }
    }

    public void removeObject(DeviceObject parent) {
        LinkedList<DeviceObject> objList = MDOUtils.GetAllDecent(this.getObjects(), parent);
        objList.add(parent);
        for (DeviceObject obj : objList) {
            obj.setId(-1);
            obj.setParentId(-1);
        }
        this.getObjects().removeAll(objList);
        this.updateObx4();
    }

    public void setObjects(List<DeviceObject> mDObjects) {
        this.mdobjects = mDObjects;
    }

    public void setResume(ProfileResume resume) {
        this.resume = resume;
    }

    public void sort() {
        Collections.sort(this.getObjects(), new MDObjectComparator());
    }

    public String toString() {
        return this.resume.toString();
    }

    public void trim() {
        for (DeviceObject object : this.getObjects()) {
            object.setDimRefid(object.getDimRefid().trim());
            object.setDimName(object.getDimName().trim());
            if (object.getRefid() == null) continue;
            object.setRefid(object.getRefid().trim().toUpperCase());
        }
    }

    public void updateObx4() {
        try {
            OBX4Utils.updateOBX4(this);
        }
        catch (ICSException iCSException) {
            // empty catch block
        }
    }
}

