/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.common;

import gov.nist.healthcare.dev.profile.common.ICSException;
import gov.nist.healthcare.deviceProfile.domain.common.MDObjectComparator;
import gov.nist.healthcare.deviceProfile.domain.common.OBX4Utils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.rch.TreeNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MDOUtils {
    public static List<DeviceObject> cloneList(List<DeviceObject> src) {
        List<DeviceObject> dest = Collections.synchronizedList(new LinkedList());
        for (DeviceObject obj : src) {
            try {
                dest.add((DeviceObject)obj.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return dest;
    }

    public static List<DeviceObject> copyList(List<DeviceObject> src) {
        List<DeviceObject> dest = Arrays.asList(new DeviceObject[src.size()]);
        Collections.copy(dest, src);
        return dest;
    }

    public static Object deepClone(Object src) {
        Object o = null;
        try {
            if (src != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(src);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                o = ois.readObject();
                ois.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return o;
    }

    public static TreeNode dumpTree(List<DeviceObject> mdobjects) throws Exception {
        TreeNode root = new TreeNode(MDOUtils.GetRoot(mdobjects));
        return MDOUtils.setupTreeNode(root, mdobjects);
    }

    public static LinkedList<DeviceObject> getAllDecent(List<DeviceObject> objects, DeviceObject parent, LinkedList<DeviceObject> dst) {
        LinkedList<DeviceObject> childrenList = MDOUtils.GetChildren(objects, parent);
        for (DeviceObject child : childrenList) {
            dst.add(child);
            MDOUtils.getAllDecent(objects, child, dst);
        }
        return dst;
    }

    public static LinkedList<DeviceObject> GetAllDecent(List<DeviceObject> objects, DeviceObject parent) {
        return MDOUtils.getAllDecent(objects, parent, new LinkedList<DeviceObject>());
    }

    public static LinkedList<DeviceObject> GetChildren(List<DeviceObject> objects, DeviceObject obj) {
        LinkedList<DeviceObject> ret = new LinkedList<DeviceObject>();
        for (DeviceObject _obj : objects) {
            if (!_obj.getParentId().equals(obj.getId())) continue;
            ret.add(_obj);
        }
        Collections.sort(ret, new MDObjectComparator());
        return ret;
    }

    public static List<DeviceObject> GetChildrenByDimRefid(String refid, DeviceObject obj, List<DeviceObject> dimObjectList) {
        ArrayList<DeviceObject> retList = new ArrayList<DeviceObject>();
        for (DeviceObject tmp : MDOUtils.GetChildren(dimObjectList, obj)) {
            if (tmp.getDimRefid().indexOf(refid) == -1) continue;
            retList.add(tmp);
        }
        return retList;
    }

    public static DeviceObject GetObjById(Integer id, List<DeviceObject> objects) {
        List<DeviceObject> mdos = objects;
        for (DeviceObject mdo : mdos) {
            if (!mdo.getId().equals(id)) continue;
            return mdo;
        }
        return null;
    }

    public static DeviceObject GetParent(List<DeviceObject> objects, DeviceObject dimOb) {
        for (DeviceObject ob : objects) {
            if (!ob.getId().equals(dimOb.getParentId())) continue;
            return ob;
        }
        return null;
    }

    public static DeviceObject GetRoot(List<DeviceObject> objects) throws ICSException {
        DeviceObject obj = MDOUtils.GetObjById(0, objects);
        if (obj == null) {
            throw new ICSException("Root Not Found");
        }
        return obj;
    }

    public static Integer IDGeneration(List<DeviceObject> objects) {
        Integer id = 0;
        for (DeviceObject obj : objects) {
            if (obj.getId() < id) continue;
            id = obj.getId() + 1;
        }
        return id;
    }

    public static boolean isCompoundMetric(DeviceObject mdo, List<DeviceObject> objects) {
        LinkedList<DeviceObject> children;
        String dimrefid = mdo.getDimRefid();
        return dimrefid.indexOf("MDC_MOC_VMO_METRIC") != -1 && dimrefid.indexOf("MDC_MOC_VMO_METRIC_CMPLX") == -1 && (children = MDOUtils.GetChildren(objects, mdo)).size() > 0;
    }

    public static void moveObjects(List<DeviceObject> objects, DeviceObject parent, DeviceObject child, int pos) {
        child.setParentId(parent.getId());
        LinkedList<DeviceObject> childrenList = MDOUtils.GetChildren(objects, parent);
        int index = childrenList.indexOf(child);
        childrenList.remove(index);
        if (index < pos) {
            --pos;
        }
        childrenList.add(pos, child);
        OBX4Utils.buildOBX4(parent, childrenList);
        OBX4Utils.updateOBX4(parent, objects);
        Collections.sort(objects, new MDObjectComparator());
    }

    public static TreeNode setupTreeNode(TreeNode node, List<DeviceObject> mdobjects) {
        for (DeviceObject obj : MDOUtils.GetChildren(mdobjects, node.getObject())) {
            TreeNode child = new TreeNode(obj, node.getLevel() + 1);
            node.getChildren().add(child);
            MDOUtils.setupTreeNode(child, mdobjects);
        }
        return node;
    }
}

