/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.table;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ICSTable
extends JTable {
    public static int count = 0;
    private static final int columnMinWidth = 30;
    private static final int rowHeight = 20;
    public int maxRowCount = 6;
    protected boolean bSelected = false;
    protected JScrollPane scrollPane;
    private final int columnCount = 5;

    public ICSTable() {
        this.setAutoCreateRowSorter(true);
        this.setPreferredScrollableViewportSize(new Dimension(150, this.maxRowCount * 20));
        this.setRowHeight(20);
        this.setAutoResizeMode(2);
        this.setFillsViewportHeight(true);
        MyMouseAdapter mma = new MyMouseAdapter();
        this.addMouseListener(mma);
        this.addMouseMotionListener(mma);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void refresh() {
    }

    public void resizeTable(Boolean bool) {
        Dimension containerwidth = null;
        containerwidth = this.getScrollPane().getSize();
        if (!bool.booleanValue()) {
            containerwidth = this.getScrollPane().getPreferredSize();
        }
        int allwidth = this.getTable().getIntercellSpacing().width;
        for (int j = 0; j < this.getTable().getColumnCount(); ++j) {
            ArrayList<Integer> valueList = new ArrayList<Integer>();
            int avgwidth = 0;
            for (int i = 0; i < this.getTable().getRowCount(); ++i) {
                int width = this.getTable().getCellRenderer((int)i, (int)j).getTableCellRendererComponent((JTable)this.getTable(), (Object)this.getTable().getValueAt((int)i, (int)j), (boolean)false, (boolean)false, (int)i, (int)j).getPreferredSize().width;
                valueList.add(width);
            }
            avgwidth = this.popularValue(valueList);
            int headerwidth = this.getTable().getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this.getTable(), (Object)this.getTable().getColumnModel().getColumn((int)j).getIdentifier(), (boolean)false, (boolean)false, (int)-1, (int)j).getPreferredSize().width;
            this.getTable().getColumnModel().getColumn(j).setPreferredWidth(avgwidth += headerwidth);
            allwidth += avgwidth + this.getTable().getIntercellSpacing().width;
        }
        allwidth += this.getTable().getIntercellSpacing().width;
        if (containerwidth.width <= 0) {
            this.getTable().setAutoResizeMode(2);
        } else if (allwidth > containerwidth.width) {
            this.getTable().setAutoResizeMode(0);
        } else {
            this.getTable().setAutoResizeMode(2);
        }
        this.setPreferredScrollableViewportSize(new Dimension(allwidth, this.maxRowCount * 20));
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
        this.getScrollPane().setPreferredSize(this.getTable().getPreferredScrollableViewportSize());
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    public void setupMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
        this.setPreferredScrollableViewportSize(new Dimension(150, maxRowCount * 20));
    }

    protected ICSTable getTable() {
        return this;
    }

    private int popularValue(List<Integer> valueList) {
        Collections.sort(valueList);
        int size = (int)((double)valueList.size() * 0.8);
        if (size > 0) {
            return valueList.get(size);
        }
        return 0;
    }

    class MyMouseAdapter
    implements MouseMotionListener,
    MouseListener {
        public int itsRow;
        public int itsColumn;

        MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 3 && e.getButton() == 1) {
                JTable jTable = (JTable)e.getSource();
                if (ICSTable.this.bSelected) {
                    jTable.removeRowSelectionInterval(this.itsRow, this.itsRow);
                }
                if (e.getClickCount() >= 2) {
                    // empty if block
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable jTable = (JTable)e.getSource();
            this.itsRow = jTable.rowAtPoint(e.getPoint());
            this.itsColumn = jTable.columnAtPoint(e.getPoint());
            ICSTable.this.bSelected = jTable.isRowSelected(this.itsRow);
            jTable.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

