/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.autocompletion.textfield;

import gov.nist.healthcare.dev.profile.common.trace.TimeDiff;
import gov.nist.healthcare.mdc.applib.autocompletion.textfield.AutoCompletionFilter;
import gov.nist.healthcare.mdc.applib.autocompletion.textfield.ListPopup;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AutoCompletionTextField
extends JTextField
implements ListSelectionListener,
ActionListener,
KeyListener,
MouseListener,
DocumentListener {
    private static int DEFAULT_PREFERRED_HEIGHT = 250;
    private AutoCompletionFilter filter;
    private ListPopup popup;
    private int preferredHeight = DEFAULT_PREFERRED_HEIGHT;

    public AutoCompletionTextField() {
        this.setup();
    }

    public AutoCompletionTextField(AutoCompletionFilter f) {
        this.setup();
        this.setFilter(f);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.popup.isVisible()) {
            Object o = this.popup.getSelectedValue();
            if (o != null) {
                this.setText(o.toString());
            }
            this.popup.setVisible(false);
        }
        this.selectAll();
        this.requestFocus();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 40) {
            if (this.popup.isVisible()) {
                if (!this.popup.isSelected()) {
                    this.popup.setSelectedIndex(0);
                } else {
                    this.popup.setSelectedIndex(this.popup.getSelectedIndex() + 1);
                }
            }
        } else if (e.getKeyCode() == 38) {
            if (this.popup.isVisible()) {
                if (!this.popup.isSelected()) {
                    this.popup.setLastOneSelected();
                } else {
                    this.popup.setSelectedIndex(this.popup.getSelectedIndex() - 1);
                }
            }
        } else if (e.getKeyCode() == 34) {
            if (this.popup.isVisible()) {
                if (!this.popup.isSelected()) {
                    this.popup.setSelectedIndex(0);
                } else {
                    this.popup.setSelectedIndex(this.popup.getSelectedIndex() + 5);
                }
            }
        } else if (e.getKeyCode() == 33) {
            if (this.popup.isVisible()) {
                if (!this.popup.isSelected()) {
                    this.popup.setLastOneSelected();
                } else {
                    this.popup.setSelectedIndex(this.popup.getSelectedIndex() - 5);
                }
            }
        } else if (e.getKeyCode() != 10) {
            this.textChanged();
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && !this.popup.isVisible()) {
            this.textChanged();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    public void setFilter(AutoCompletionFilter f) {
        this.filter = f;
    }

    public void setPopupPreferredHeight(int h) {
        this.preferredHeight = h;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList list = (JList)e.getSource();
        String text = list.getSelectedValue().toString();
        this.setText(text);
        this.popup.setVisible(false);
    }

    private void changeList(List<String> array) {
        if (array.size() == 0) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
        } else if (!this.popup.isVisible()) {
            this.showPopup();
        }
        if (this.isListChange(array) && array.size() != 0) {
            this.popup.setList(array);
        }
    }

    private boolean isListChange(List array) {
        if (array.size() != this.popup.getItemCount()) {
            return true;
        }
        for (int i = 0; i < array.size(); ++i) {
            if (array.get(i).equals(this.popup.getItem(i))) continue;
            return true;
        }
        return false;
    }

    private void setup() {
        this.setBackground(new Color(252, 245, 223));
        this.popup = new ListPopup();
        this.popup.addListSelectionListener(this);
        this.addKeyListener(this);
        this.addActionListener(this);
        this.addMouseListener(this);
        this.getDocument().addDocumentListener(this);
    }

    private void showPopup() {
        this.popup.setPopupSize(this.getWidth(), this.preferredHeight);
        this.popup.show(this, 0, this.getHeight() - 1);
    }

    private void textChanged() {
        if (!this.popup.isVisible() && !this.getText().equals("")) {
            this.showPopup();
            this.requestFocus();
        }
        if (this.filter != null) {
            this.updateList();
        }
    }

    private void updateList() {
        ExecutorService exec = Executors.newFixedThreadPool(1);
        Callable<List<String>> call = new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                List<String> ret = AutoCompletionTextField.this.filter.filter(AutoCompletionTextField.this.getText());
                return ret;
            }
        };
        try {
            TimeDiff tDiff = new TimeDiff();
            Future<List<String>> future = exec.submit(call);
            List<String> obj = future.get(10000L, TimeUnit.MILLISECONDS);
            System.out.println("Future List takes " + tDiff.getDiff());
            this.changeList(obj);
        }
        catch (TimeoutException ex) {
            System.out.println("====================task time out===============");
            ex.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("failed to handle.");
            e.printStackTrace();
        }
        exec.shutdown();
    }
}

