/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.tabbed;

import gov.nist.healthcare.mdc.framework.lifecycle.Lifecycle;
import gov.nist.healthcare.mdc.framework.mvc.AbsView;
import gov.nist.healthcare.mdc.framework.mvc.View;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedView
extends AbsView
implements ChangeListener {
    private static final Logger log = Logger.getLogger(TabbedView.class.getName());
    protected JTabbedPane _tabbedPane;
    protected CardLayout cardLayout;
    protected LinkedList<Object> objects = new LinkedList();

    public Component add(String label, Component comp) {
        this.getObjects().add(comp);
        return this.getView().add(label, comp);
    }

    public Component add(View v) {
        this.getObjects().add(v);
        return this.getView().add(v.getName(), v.getView());
    }

    @Override
    public void createGUI() {
    }

    public List<Component> getComponents() {
        LinkedList<Component> ret = new LinkedList<Component>();
        for (int i = 0; i < ((JTabbedPane)this.getView()).getTabCount(); ++i) {
            Component comp = ((JTabbedPane)this.getView()).getComponentAt(i);
            ret.add(comp);
        }
        return ret;
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    @Override
    public JComponent getView() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JTabbedPane();
            this._tabbedPane.setVisible(true);
            this._tabbedPane.addChangeListener(this);
        }
        return this._tabbedPane;
    }

    @Override
    public void refresh() {
        int index = this._tabbedPane.getSelectedIndex();
        Object comp = this.getObjects().get(index);
        if (comp instanceof Lifecycle) {
            ((Lifecycle)comp).refresh();
        }
    }

    @Override
    public void reset() {
        int index = this._tabbedPane.getSelectedIndex();
        Object comp = this.getObjects().get(index);
        if (comp instanceof Lifecycle) {
            ((Lifecycle)comp).reset();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh();
    }
}

