/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.box.dataview;

import gov.nist.healthcare.mdc.applib.box.DefaultBox;
import gov.nist.healthcare.mdc.applib.box.table.TableBox;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class DataViewBox
extends TableBox {
    public int searchColumnNumber = 0;
    public int tableselectMagicNumber = 0;
    protected JTextField filterText;
    protected JLabel searchingLabel;
    protected TableRowSorter<TableModel> sorter;

    public static DataViewBox dataViewBoxFactory(int maxRowCount, String label, AbstractTableModel dataModel) {
        DataViewBox dataViewBox = new DataViewBox(maxRowCount, label);
        dataViewBox.setModel(dataModel);
        return dataViewBox;
    }

    public static DataViewBox dataViewBoxFactory(String label) {
        DataViewBox dataViewBox = new DataViewBox(label);
        return dataViewBox;
    }

    public static DataViewBox dataViewBoxFactory(String label, DefaultTableModel dataModel) {
        DataViewBox dataViewBox = new DataViewBox(label);
        dataViewBox.setModel(dataModel);
        return dataViewBox;
    }

    public DataViewBox(int maxRowCount, String label) {
        super(label);
        this.buildWindow(maxRowCount);
    }

    public DataViewBox(String label) {
        super(label);
        this.buildWindow(20);
    }

    @Override
    public void itemClicked() {
        if (this.itemClickActioner != null) {
            int row = this.tablePane.getTable().getSelectedRow();
            if (row != -1) {
                Object obj = this.tablePane.getTable().getValueAt(row, this.tableselectMagicNumber);
                this.itemClickActioner.clickedAction(obj);
            } else {
                super.itemClicked();
            }
        }
    }

    @Override
    public void setModel(AbstractTableModel dataModel) {
        super.setModel(dataModel);
        super.refresh();
        this.sorter = new TableRowSorter<AbstractTableModel>(dataModel);
        this.tablePane.getTable().setRowSorter(this.sorter);
        this.searchingLabel.setText(this.tablePane.getTable().getColumnName(this.searchColumnNumber) + " search ");
    }

    protected void buildWindow(int maxRowCount) {
        this.setCollapse(false);
        this.filterText = new JTextField();
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DataViewBox.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DataViewBox.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DataViewBox.this.newFilter();
            }
        });
        JPanel searchingPanel = new JPanel();
        searchingPanel.setLayout(new BoxLayout(searchingPanel, 2));
        searchingPanel.add(this.filterText);
        this.searchingLabel = new JLabel("search");
        this.addComponent(DefaultBox.getLinePanel(this.searchingLabel, (JComponent)searchingPanel));
        this.tablePane.getTable().maxRowCount = maxRowCount;
    }

    private void newFilter() {
        RowFilter rf = null;
        try {
            rf = RowFilter.regexFilter(this.filterText.getText().toUpperCase(), this.searchColumnNumber);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.sorter.setRowFilter(rf);
    }
}

