/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view.tree;

import gov.nist.healthcare.mdc.icsgenerator.view.tree.TreeObject;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeTransferHandler
extends TransferHandler {
    private static final Logger log = Logger.getLogger(TreeTransferHandler.class.getName());
    DataFlavor[] flavors = new DataFlavor[1];
    DataFlavor nodesFlavor;
    DefaultMutableTreeNode[] nodesToRemove;

    public TreeTransferHandler() {
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ClassNotFound: " + e.getMessage());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        log.info("isDrop");
        if (!support.isDrop()) {
            return false;
        }
        log.info("isDataFlavorSupported");
        support.setShowDropLocation(true);
        if (!support.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        log.info("Do not allow a drop on the drag source selections.");
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        JTree tree = (JTree)support.getComponent();
        int dropRow = tree.getRowForPath(dl.getPath());
        int[] selRows = tree.getSelectionRows();
        for (int i = 0; i < selRows.length; ++i) {
            if (selRows[i] != dropRow) continue;
            return false;
        }
        log.info("Do not allow MOVE-action drops if a non-leaf node is selected unless all of its children are also selected.");
        int action = support.getDropAction();
        if (action == 2) {
            return this.haveCompleteNode(tree);
        }
        log.info("Do not allow a non-leaf node to be copied to a level which is less than its source level.");
        TreePath dest = dl.getPath();
        DefaultMutableTreeNode target = (DefaultMutableTreeNode)dest.getLastPathComponent();
        TreePath path = tree.getPathForRow(selRows[0]);
        DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (firstNode.getChildCount() > 0 && target.getLevel() < firstNode.getLevel()) {
            return false;
        }
        log.info(" true");
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        DefaultMutableTreeNode[] nodes = null;
        try {
            Transferable t = support.getTransferable();
            nodes = (DefaultMutableTreeNode[])t.getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("UnsupportedFlavor: " + ufe.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("I/O error: " + ioe.getMessage());
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        int childIndex = dl.getChildIndex();
        TreePath dest = dl.getPath();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dest.getLastPathComponent();
        JTree tree = (JTree)support.getComponent();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        int index = childIndex;
        if (childIndex == -1) {
            index = parent.getChildCount();
        }
        log.info("index " + index);
        if (parent.getUserObject() instanceof TreeObject) {
            ((TreeObject)parent.getUserObject()).insertNodeInto(nodes[0], index);
        }
        model.insertNodeInto(nodes[0], parent, index++);
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            ArrayList<DefaultMutableTreeNode> copies = new ArrayList<DefaultMutableTreeNode>();
            ArrayList<DefaultMutableTreeNode> toRemove = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            DefaultMutableTreeNode copy = this.copy(node, copies, toRemove);
            DefaultMutableTreeNode[] nodes = copies.toArray(new DefaultMutableTreeNode[copies.size()]);
            this.nodesToRemove = toRemove.toArray(new DefaultMutableTreeNode[toRemove.size()]);
            log.info(copy.getUserObject().toString() + " " + paths.length + " " + copies.size() + " " + toRemove.size());
            return new NodesTransferable(nodes);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if ((action & 2) == 2) {
            JTree tree = (JTree)source;
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            for (int i = 0; i < this.nodesToRemove.length; ++i) {
                model.removeNodeFromParent(this.nodesToRemove[i]);
            }
        }
    }

    private DefaultMutableTreeNode copy(DefaultMutableTreeNode node, List<DefaultMutableTreeNode> copies, List<DefaultMutableTreeNode> toRemove) {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode();
        ret.setUserObject(node.getUserObject());
        copies.add(ret);
        toRemove.add(node);
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                ret.add(this.copy((DefaultMutableTreeNode)node.getChildAt(i), copies, toRemove));
            }
        }
        return ret;
    }

    private boolean haveCompleteNode(JTree tree) {
        int[] selRows = tree.getSelectionRows();
        TreePath path = tree.getPathForRow(selRows[0]);
        DefaultMutableTreeNode first = (DefaultMutableTreeNode)path.getLastPathComponent();
        int childCount = first.getChildCount();
        for (int i = 1; i < selRows.length; ++i) {
            path = tree.getPathForRow(selRows[i]);
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (first.isNodeChild(next) && childCount <= selRows.length - 1) continue;
        }
        return true;
    }

    public class NodesTransferable
    implements Transferable {
        DefaultMutableTreeNode[] nodes;

        public NodesTransferable(DefaultMutableTreeNode[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return TreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return TreeTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

