/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view.box;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceEnumGroup;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.mdc.applib.box.table.TableBox;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditControl;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditModel;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import gov.nist.healthcare.mdc.icsgenerator.control.view.FrameController;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

public class EnumBox
extends TableBox
implements ItemListener,
PropertyChangeListener {
    private static final Logger log = Logger.getLogger(EnumBox.class.getName());
    protected ICSAppControl applicationInstance = ICSAppControl.GetInstance();
    protected Map<String, DeviceEnumGroup> groupMap = new HashMap<String, DeviceEnumGroup>();
    protected JComboBox groupSelector;
    protected ListEditControl tableListEditControl;

    public EnumBox() {
        super("Enumerations", 7);
        this.setupToolbar();
        this.setVisible(false);
    }

    @Override
    public void deleteButtonClicked() {
        int[] selectedRowsIndices = this.tablePane.getTable().getSelectedRows();
        DefaultTableModel model = (DefaultTableModel)this.tablePane.getModel();
        for (int indice : selectedRowsIndices) {
            String enumValue = (String)model.getValueAt(indice, 0);
            for (ListEditModel ele : this.tableRowList) {
                if (!ele.getObject().toString().equalsIgnoreCase(enumValue)) continue;
                ele.setInDestList(false);
            }
        }
        this.updateModel();
        this.refresh();
    }

    @Override
    public void editButtonClicked() {
        this.tableListEditControl = new ListEditControl(FrameController.getFrame(), this.tableRowList, this.getName());
        this.tableListEditControl.showListEditView();
        this.updateModel();
        this.refresh();
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        String item = evt.getItem().toString();
        Object selectedObj = this.groupSelector.getSelectedItem();
        String selectedItem = "";
        if (selectedObj != null) {
            selectedItem = selectedObj.toString();
        }
        if (item.equals(selectedItem)) {
            System.out.println("itemStateChanged " + item + "   " + selectedItem);
            this.clearTableRow();
            DeviceObject currObj = this.applicationInstance.getCurrentMDObject();
            if (currObj != null) {
                currObj.getEnumGroups().clear();
            }
            DeviceEnumGroup grp = null;
            grp = item.startsWith("Saved") ? this.groupMap.get("Saved") : this.groupMap.get(item);
            if (grp != null) {
                this.setupTableRow(grp.getEnumValues());
                if (currObj != null) {
                    currObj.getEnumGroups().add(0, grp);
                    log.info("Size " + currObj.getEnumGroups().size());
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("refid")) {
            log.info(" id: " + evt.getPropertyName() + " = [" + evt.getOldValue() + "->" + evt.getNewValue() + "]");
            this.initUI();
            this.setupGroup();
        }
    }

    @Override
    public void refresh() {
        DeviceObject obj = this.applicationInstance.getCurrentMDObject();
        if (obj != null && obj.getDimObject().getName().equalsIgnoreCase("Enumeration")) {
            obj.getPropertyChangeSupport().addPropertyChangeListener(this);
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.addEnumObsAtt();
        this.setupGroup();
    }

    @Override
    public void reset() {
        this.setVisible(false);
        this.initUI();
    }

    @Override
    protected DefaultTableModel getDefaultTableModel(List<ListEditModel> dimUnitList) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Enum Values");
        for (ListEditModel raw : dimUnitList) {
            if (!raw.isInDestList().booleanValue()) continue;
            String unit = raw.getObject().toString();
            Object[] rowData = new Object[]{unit};
            defaultTableModel.addRow(rowData);
        }
        return defaultTableModel;
    }

    @Override
    protected void setupToolbar() {
        this.groupSelector = new JComboBox();
        JPanel optionPanelToolBar = new JPanel();
        optionPanelToolBar.setLayout(new BoxLayout(optionPanelToolBar, 2));
        optionPanelToolBar.add(this.groupSelector);
        this.setHeadComponent(optionPanelToolBar);
    }

    private void addEnumObsAtt() {
        DimObject dimObj;
        DimAttribute att;
        DeviceObject _md_object = this.applicationInstance.getCurrentMDObject();
        if (_md_object != null && _md_object.getEnumSet().size() > 0 && (att = this.getAttribute("Enum-Observed-Value", (dimObj = this.applicationInstance.getBuilder().fetchDimObjectFromDB(_md_object)).getDimAttributes())) != null) {
            log.info(att.getName());
            StringBuffer buf = new StringBuffer("");
            for (String enumValue : _md_object.getEnumSet()) {
                buf.append(enumValue + ",");
            }
            log.info(buf.toString());
            if (!_md_object.getDimObject().getDimAttributes().contains(att)) {
                log.info("not exist");
                att.setValidValues(buf.toString());
                _md_object.getDimObject().getDimAttributes().add(att);
            } else {
                log.info("exist");
                int index = _md_object.getDimObject().getDimAttributes().indexOf(att);
                DimAttribute obj = (DimAttribute)_md_object.getDimObject().getDimAttributes().get(index);
                obj.setValidValues(buf.toString());
            }
        }
    }

    private DimAttribute getAttribute(String name, List<DimAttribute> attrs) {
        for (DimAttribute att : attrs) {
            if (!att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    private void initUI() {
        this.clearTableRow();
        this.groupSelector.removeItemListener(this);
        this.groupSelector.removeAllItems();
        this.groupMap = new HashMap<String, DeviceEnumGroup>();
    }

    private void setupGroup() {
        this.setupGroupMap();
        this.groupSelector.removeItemListener(this);
        this.groupSelector.addItem("");
        for (Map.Entry<String, DeviceEnumGroup> e : this.groupMap.entrySet()) {
            String key = e.getKey();
            DeviceEnumGroup grp = e.getValue();
            if (grp == null) continue;
            if (key.equals("Saved")) {
                this.groupSelector.addItem("Saved " + grp.getEnumGroup());
                this.groupSelector.setSelectedItem("Saved " + grp.getEnumGroup());
                this.setupTableRow(grp.getEnumValues());
                continue;
            }
            this.groupSelector.addItem(key);
        }
        this.groupSelector.addItemListener(this);
    }

    private void setupGroupMap() {
        DeviceObject currObj = this.applicationInstance.getCurrentMDObject();
        DeviceObject tmp = null;
        if (currObj != null) {
            log.info("Size " + currObj.getEnumGroups().size());
            if (currObj.getEnumGroups().size() > 0) {
                this.groupMap.put("Saved", (DeviceEnumGroup)currObj.getEnumGroups().get(0));
            }
            tmp = this.applicationInstance.getBuilder().updateUnitEnum(currObj.getRefid());
        }
        if (tmp != null) {
            for (DeviceEnumGroup grp : tmp.getEnumGroups()) {
                this.groupMap.put(grp.getEnumGroup(), grp);
            }
        }
        this.groupMap.put("", null);
    }

    private void updateModel() {
        DeviceObject _md_object = this.applicationInstance.getCurrentMDObject();
        if (_md_object != null) {
            _md_object.getEnumSet().clear();
            for (ListEditModel ele : this.tableRowList) {
                if (!ele.isInDestList().booleanValue()) continue;
                _md_object.getEnumSet().add((String)ele.getObject());
            }
            this.addEnumObsAtt();
        }
        this.updateEditButtonTxt(this.tableRowList);
    }

    List<DeviceEnumGroup> getGroups() {
        DeviceObject currObj = this.applicationInstance.getCurrentMDObject();
        if (currObj != null) {
            return currObj.getEnumGroups();
        }
        return null;
    }
}

