/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view;

import gov.nist.healthcare.mdc.framework.action.ApplicationAction;
import gov.nist.healthcare.mdc.framework.module.ViewModule;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ToolBar
extends JToolBar {
    public List<JComponent> viewButtonList;
    protected List<ViewModule> viewControlList;

    public ToolBar() {
        this.setFloatable(false);
        this.setFocusable(false);
    }

    public void reset(String buttonName) {
        ArrayList viewToolbar = new ArrayList();
        this.getViewButtonList().clear();
        this.getViewButtonList().add(new JToolBar.Separator());
        Action toolsAction = ApplicationAction.actionMap.get("Views");
        this.add(new JToolBar.Separator());
        for (ViewModule vc : this.viewControlList) {
            JToggleButton button = new JToggleButton(toolsAction);
            button.setText(vc.getName());
            button.setToolTipText(vc.getName());
            button.setFocusable(false);
            if (vc.getName().equals(buttonName)) {
                button.setSelected(true);
            } else {
                button.setSelected(false);
            }
            this.getViewButtonList().add(button);
            this.getViewButtonList().add(new JToolBar.Separator());
        }
        this.removeAll();
        for (JComponent abButton : this.getViewButtonList()) {
            this.add(abButton);
        }
        this.updateUI();
    }

    public void setViewControlList(List<ViewModule> _viewControlList) {
        this.viewControlList = _viewControlList;
    }

    private List<JComponent> getViewButtonList() {
        if (this.viewButtonList == null) {
            this.viewButtonList = new ArrayList<JComponent>();
        }
        return this.viewButtonList;
    }
}

