/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.model;

import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import gov.nist.healthcare.mdc.icsgenerator.view.tree.TreeObject;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class ICSTreeObject
implements TreeObject {
    protected DeviceObject mdo;

    public ICSTreeObject(DeviceObject obj) {
        this.mdo = obj;
    }

    @Override
    public DeviceObject getMDObject() {
        return this.mdo;
    }

    @Override
    public Integer getObjectId() {
        return this.mdo.getId();
    }

    public Integer getObjectParentId() {
        return this.mdo.getParentId();
    }

    @Override
    public void insertNodeInto(DefaultMutableTreeNode node, int pos) {
        DeviceObject child = ((ICSTreeObject)node.getUserObject()).getMDObject();
        MDOUtils.moveObjects((List)ICSAppControl.GetInstance().getProfile().getObjects(), (DeviceObject)this.getMDObject(), (DeviceObject)child, (int)pos);
    }

    public String toString() {
        if (this.mdo.getDimName().equals("DIM")) {
            return "Profile";
        }
        String ret = new String("Blank Object");
        String name = this.mdo.getName();
        String dimname = this.mdo.getDimName();
        String obx4 = this.mdo.getObx4();
        List objects = ICSAppControl.GetInstance().getProfile().getObjects();
        Boolean compound = MDOUtils.isCompoundMetric((DeviceObject)this.mdo, (List)objects);
        if (!dimname.equals("")) {
            ret = dimname;
            if (compound.booleanValue()) {
                ret = "Compound " + ret;
            }
        }
        if (name != null) {
            ret = name + " [" + ret + "]";
        }
        return obx4 + " " + ret;
    }
}

