/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control.conformance.view;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomToTableModelAdapter
extends AbstractTableModel {
    protected ArrayList<String> columnNames = new ArrayList();
    protected ArrayList<ArrayList<String>> data = new ArrayList();
    protected Document dom;

    public DomToTableModelAdapter(Document docIn) {
        this.dom = docIn;
        this.fillData();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    public Document getDoc() {
        return this.dom;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ArrayList<String> row;
        String res = "";
        if (this.data.size() > rowIndex && (row = this.data.get(rowIndex)).size() > columnIndex) {
            res = row.get(columnIndex);
        }
        res = "<html>" + res + "</html>";
        return res;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean bool = false;
        if (columnIndex == 4 || columnIndex == 5) {
            bool = true;
        }
        return bool;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ArrayList<String> list = this.data.get(row);
        String res = value.toString();
        res = res.replaceAll("<html>", "");
        res = res.replaceAll("</html>", "");
        list.set(col, res);
        this.fireTableCellUpdated(row, col);
    }

    protected void fillData() {
        Element racine = this.dom.getDocumentElement();
        if (racine.hasChildNodes()) {
            NodeList list = racine.getChildNodes();
            boolean first = true;
            for (int i = 0; i < list.getLength(); ++i) {
                Node raw = list.item(i);
                if (raw.getNodeType() != 1) continue;
                NodeList list2 = raw.getChildNodes();
                ArrayList<String> strList = new ArrayList<String>();
                for (int j = 0; j < list2.getLength(); ++j) {
                    Node child;
                    Node column = list2.item(j);
                    if (column.getNodeType() != 1) continue;
                    if (first) {
                        String name = column.getNodeName();
                        this.columnNames.add(name);
                    }
                    for (child = column.getFirstChild(); child != null && child.getNodeType() != 3; child = child.getNextSibling()) {
                    }
                    String text = "";
                    if (child != null) {
                        text = child.getNodeValue();
                    }
                    strList.add(text);
                }
                if (first) {
                    first = false;
                }
                this.data.add(strList);
            }
        }
    }
}

