/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view.box;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.mdc.applib.beanbinding.BeanBinding;
import gov.nist.healthcare.mdc.applib.beanbinding.TextComponentBeanBinding;
import gov.nist.healthcare.mdc.applib.box.dataview.DataViewBox;
import gov.nist.healthcare.mdc.applib.box.dataview.DataViewBoxesPanel;
import gov.nist.healthcare.mdc.framework.Application;
import gov.nist.healthcare.mdc.icsgenerator.control.dataview.model.DimObjectTableModel;
import gov.nist.healthcare.mdc.icsgenerator.view.ElementBox;
import gov.nist.healthcare.mdc.icsgenerator.view.TextFieldDialog;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JTextField;

public class DimObjectBox
extends ElementBox {
    private static final Logger log = Logger.getLogger(DimObjectBox.class.getName());
    private JTextField name;

    public DimObjectBox() {
        super("DIM [ISO/IEEE 11073:10201]");
        this.initialize();
    }

    @Override
    public void createGUI() {
        BeanBinding namebb = bdManager.bind(this.addTextField("Object Name", true), DimObject.class, "name");
        bdManager.bind(this.addTextField("Reference ID", false), DimObject.class, "refid");
        bdManager.bind(this.addTextField("Term Code", false), DimObject.class, "termcode");
        bdManager.bind(this.addTextField("Clause", false), DimObject.class, "clause");
        this.name = (JTextField)((TextComponentBeanBinding)namebb).getTextComponent();
        this.name.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                DimObjectBox.this.invokeDialog(arg0);
            }
        });
    }

    private DimObjectTableModel getModel() {
        DeviceObject parent = this.icsapp.getProfile().getParent(this.icsapp.getCurrentMDObject());
        List objlist = this.icsapp.getDatabase().getDimDao().getObjectChildren(new DimObject(parent.getDimName()));
        return new DimObjectTableModel(objlist);
    }

    private void invokeDialog(MouseEvent arg0) {
        String title = "DIM Database";
        DataViewBoxesPanel dataView = new DataViewBoxesPanel();
        TextFieldDialog tfDialog = new TextFieldDialog(title, dataView.getView());
        DataViewBox normBox = DataViewBox.dataViewBoxFactory(15, title, this.getModel());
        normBox.setItemClickActioner(tfDialog);
        dataView.getBoxList().add(normBox);
        dataView.assembly();
        tfDialog.run();
        if (tfDialog.obj != null) {
            this.icsapp.getCurrentMDObject().setDimName(new String(tfDialog.obj.toString()));
            this.icsapp.getCurrentMDObject().setDimRefid("");
            this.icsapp.getBuilder().updateTermcode(this.icsapp.getCurrentMDObject());
            DimObject dimObj = this.icsapp.getDimObject();
            dimObj.getDimAttributes().clear();
            dimObj.getDimBehaviors().clear();
            dimObj.getDimNotifications().clear();
            this.icsapp.getCurrentMDObject().setDimObject(dimObj);
            Application.getInstance().getLifecyle().refresh();
        }
    }
}

