/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control.dataview.view;

import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.mdc.applib.box.DefaultBox;
import gov.nist.healthcare.mdc.applib.box.panel.ICSBoxesOKCancelPanel;
import gov.nist.healthcare.mdc.icsgenerator.control.dataview.DataViewController;
import gov.nist.healthcare.mdc.icsgenerator.control.dataview.DataViewMainController;
import gov.nist.healthcare.mdc.icsgenerator.control.dataview.DimObjectViewController;
import gov.nist.healthcare.mdc.icsgenerator.control.dataview.model.DimObjectTableModel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class DimObjectDialog {
    public String title = "private term (object)";
    private final JDialog dialog;

    public DimObjectDialog(DimObject obj) {
        this.getDimObjectController();
        this.dialog = new JDialog((Frame)DataViewController.getMainFrame(), this.title);
        this.dialog.setSize(600, 650);
        this.dialog.setLayout(new GridLayout());
        this.dialog.add((Component)new DimObjectPanel(obj), "Center");
        this.getDimObjectController();
        this.dialog.setLocationRelativeTo(DimObjectViewController.getMainFrame());
        this.dialog.setVisible(true);
        this.dialog.pack();
    }

    public DimObjectViewController getDimObjectController() {
        return DataViewMainController.getInstance().getDimObjectController();
    }

    public class DimObjectPanel
    extends ICSBoxesOKCancelPanel {
        protected DimObject obj;
        protected JTextField txtMocRefid;
        protected JTextField txtMocTermcode;
        protected JTextField txtMocLabel;
        protected JTextField txtMocComment;
        protected JTextField txtObjName;
        protected JTextField txtObjRefid;
        protected JTextField txtObjTermcode;
        protected JTextField txtObjClause;

        public DimObjectPanel(DimObject obj) {
            this.obj = obj;
            this.createAndShowGUI();
        }

        @Override
        protected void cancelButtonAction() {
            DimObjectDialog.this.dialog.dispose();
        }

        @Override
        protected void okButtonAction() {
            this.obj.setName(this.txtObjName.getText());
            this.obj.setRefid(this.txtObjRefid.getText());
            this.obj.setTermcode(this.txtObjTermcode.getText());
            this.obj.setClause(this.txtObjClause.getText());
            DimObjectDialog.this.getDimObjectController().getDimDao().persist(this.obj);
            DimObjectDialog.this.getDimObjectController().getDataTablePanel().refresh();
            DimObjectDialog.this.dialog.dispose();
        }

        private void createAndShowGUI() {
            this.txtObjName = new JTextField(this.obj.getName());
            this.txtObjRefid = new JTextField(this.obj.getRefid());
            this.txtObjTermcode = new JTextField(this.obj.getTermcode());
            this.txtObjClause = new JTextField(this.obj.getClause());
            DefaultBox box = new DefaultBox(DimObjectDialog.this.title);
            String[] columnNames = DimObjectTableModel.columnNames;
            box.addComponent(DefaultBox.getLinePanel(columnNames[0], (JComponent)this.txtObjName));
            box.addComponent(DefaultBox.getLinePanel(columnNames[1], (JComponent)this.txtObjRefid));
            box.addComponent(DefaultBox.getLinePanel(columnNames[2], (JComponent)this.txtObjTermcode));
            box.addComponent(DefaultBox.getLinePanel(columnNames[3], (JComponent)this.txtObjClause));
            this.getBoxList().add(box);
            this.assembly();
        }
    }
}

