/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control.conformance;

import gov.nist.healthcare.dev.profile.control.file.xmlv1.V1XmlGenerator;
import gov.nist.healthcare.mdc.framework.module.ModuleImpl;
import gov.nist.healthcare.mdc.framework.module.ViewModule;
import gov.nist.healthcare.mdc.icsgenerator.control.conformance.ConformanceModuleModel;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Document;

public abstract class ConformanceModule
extends ModuleImpl
implements ViewModule {
    protected static ResourceBundle conformanceModuleBundle = ResourceBundle.getBundle("resources/modules/conformance/conformance");
    protected static V1XmlGenerator xmlGenerator = new V1XmlGenerator();

    public static List<ConformanceModuleModel> setupModel(String[] modulePrefix) {
        ArrayList<ConformanceModuleModel> modelList = new ArrayList<ConformanceModuleModel>();
        for (String prefix : modulePrefix) {
            ConformanceModuleModel model = ConformanceModule.modelFactory(prefix);
            if (model == null) continue;
            modelList.add(model);
        }
        return modelList;
    }

    private static String getResourceValue(String key) {
        try {
            return conformanceModuleBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "";
        }
    }

    private static ConformanceModuleModel modelFactory(String prefix) {
        ConformanceModuleModel model = new ConformanceModuleModel();
        model.setTitle(ConformanceModule.getResourceValue(prefix + ".title"));
        if (model.getTitle().equals("")) {
            return null;
        }
        model.setDescription(ConformanceModule.getResourceValue(prefix + ".description"));
        model.setTableName(ConformanceModule.getResourceValue(prefix + ".tableName"));
        model.setXmlFilePath(ConformanceModule.getResourceValue(prefix + ".xmlFilePath"));
        model.setXsltFilePath(ConformanceModule.getResourceValue(prefix + ".xsltFilePath"));
        model.setSchemaFilePath(ConformanceModule.getResourceValue(prefix + ".schemaFilePath"));
        return model;
    }

    public ConformanceModule() {
        super("Conformance Statements");
    }

    public abstract Document getDom();
}

