/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimBehavior;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimNotification;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class V1XmlGenerator {
    public static final String NAMESPACE = "http://www.nist.gov/x73DIM";
    public Document dom;

    public String domToString(Document doc) {
        String str = "";
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer1 = tFactory.newTransformer();
            transformer1.setOutputProperty("method", "xml");
            transformer1.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer1.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result2 = new StreamResult(stream);
            transformer1.transform(source, result2);
            str = stream.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public Document generateXML(List<DeviceObject> dimObjectList) throws ParserConfigurationException {
        this.dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DeviceObject icsGeneRoot = this.getRoot(dimObjectList);
        DimObject dimObjRoot = icsGeneRoot.getDimObject();
        if (dimObjRoot == null) {
            return this.dom;
        }
        Element root = this.dom.createElementNS(NAMESPACE, dimObjRoot.getName());
        this.dom.appendChild(root);
        for (DeviceObject childObj : this.getDimObjectChildren(icsGeneRoot, dimObjectList)) {
            root.appendChild(this.dimObjectElement(childObj, dimObjectList));
        }
        return this.dom;
    }

    public void saveToFile(String outputFile) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.dom);
            transformer.transform(source, result);
            FileWriter outputWriter = new FileWriter(outputFile);
            outputWriter.write(writer.toString());
            outputWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Element createElement(String elemName) {
        return this.dom.createElementNS(NAMESPACE, elemName);
    }

    protected Element createTextNodeElement(String elemName, String elemTxt) {
        Element retElem = this.createElement(elemName);
        if (elemTxt == null) {
            elemTxt = "";
        }
        retElem.appendChild(this.dom.createTextNode(elemTxt));
        return retElem;
    }

    protected Element dimAttributeElement(DimObject obj) {
        Element elem = this.createElement("Attribute_Info");
        for (DimAttribute itrObj : obj.getDimAttributes()) {
            Element xmlAttribute = this.createElement(itrObj.getName());
            xmlAttribute.setAttribute("attrGrpName", itrObj.getAttribute_group_name());
            xmlAttribute.setAttribute("attrGrpId", itrObj.getAttribute_group_id());
            xmlAttribute.setAttribute("attrGrpTermCode", itrObj.getAttribute_group_termcode());
            xmlAttribute.setAttribute("derivedFrom", itrObj.getAttribute_derived_from());
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_NAME", itrObj.getName()));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_ID", itrObj.getRefid()));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_TYPE", itrObj.getParaType()));
            xmlAttribute.appendChild(this.createTextNodeElement("TERM_CODE", itrObj.getTermcode()));
            xmlAttribute.appendChild(this.createTextNodeElement("Reference", itrObj.getClause()));
            xmlAttribute.appendChild(this.createTextNodeElement("Qual", itrObj.getParaMode()));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_ACCESS", itrObj.getAttribute_access()));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_VALUE_RANGE", itrObj.getAttribute_value_range()));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_SAMPLE_VALUE", itrObj.getAttribute_asn1_value()));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_RESTRICTIONS", ""));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_VALID_VALUES", itrObj.getValidValues()));
            xmlAttribute.appendChild(this.createTextNodeElement("ATTRIBUTE_STATIC_DYN", itrObj.getAttribute_static_dyn()));
            elem.appendChild(xmlAttribute);
        }
        return elem;
    }

    protected Element dimBehaviorElement(DimObject obj) {
        Element elem = this.createElement("Behaviour_Info");
        for (DimBehavior itrObj : obj.getDimBehaviors()) {
            Element paramElement = this.createElement(itrObj.getName());
            paramElement.appendChild(this.createTextNodeElement("METHOD_NAME", itrObj.getName()));
            paramElement.appendChild(this.createTextNodeElement("METHOD_ID", itrObj.getRefid()));
            paramElement.appendChild(this.createTextNodeElement("BEHAVIOUR_ACTION_PARAMETER", itrObj.getParaType()));
            paramElement.appendChild(this.createTextNodeElement("BEHAVIOUR_ACTION_RESULT", itrObj.getParaResult()));
            paramElement.appendChild(this.createTextNodeElement("TERM_CODE", itrObj.getTermcode()));
            paramElement.appendChild(this.createTextNodeElement("Reference", itrObj.getClause()));
            paramElement.appendChild(this.createTextNodeElement("Qual", itrObj.getParaMode()));
            paramElement.appendChild(this.createTextNodeElement("BEHAVIOUR_RESTRICTIONS", ""));
            elem.appendChild(paramElement);
        }
        return elem;
    }

    protected Element dimNotificationElement(DimObject obj) {
        Element elem = this.createElement("Notification_Info");
        for (DimNotification itrObj : obj.getDimNotifications()) {
            Element paramElement = this.createElement(itrObj.getName());
            paramElement.appendChild(this.createTextNodeElement("NOTIFICATION_NAME", itrObj.getName()));
            paramElement.appendChild(this.createTextNodeElement("NOTIFICATION_ID", itrObj.getRefid()));
            paramElement.appendChild(this.createTextNodeElement("NOTIFICATION_EVENT_PARAMETER", itrObj.getParaType()));
            paramElement.appendChild(this.createTextNodeElement("NOTIFICATION_EVENT_REPLY", itrObj.getParaResult()));
            paramElement.appendChild(this.createTextNodeElement("TERM_CODE", itrObj.getTermcode()));
            paramElement.appendChild(this.createTextNodeElement("Reference", itrObj.getClause()));
            paramElement.appendChild(this.createTextNodeElement("Qual", itrObj.getParaMode()));
            paramElement.appendChild(this.createTextNodeElement("NOTIFICATION_RESTRICTIONS", ""));
            elem.appendChild(paramElement);
        }
        return elem;
    }

    protected Element dimObjectElement(DeviceObject _obj, List<DeviceObject> dimObjectList) {
        DimObject obj = _obj.getDimObject();
        String name = obj.getName();
        name = name.replaceAll(" ", "_");
        Element elem = this.createElement(name);
        Element objectName = this.createTextNodeElement("OBJECT_NAME", obj.getName());
        objectName.setAttribute("Label", _obj.getName());
        elem.appendChild(objectName);
        elem.appendChild(this.createTextNodeElement("OBJECT_ID", obj.getRefid()));
        elem.appendChild(this.createTextNodeElement("TERM_CODE", obj.getTermcode()));
        elem.appendChild(this.createTextNodeElement("Reference", obj.getClause()));
        elem.appendChild(this.createTextNodeElement("MOC_RESTRICTIONS", ""));
        elem.appendChild(this.createTextNodeElement("MOC_TYPE_ID", _obj.getRefid()));
        elem.appendChild(this.createTextNodeElement("MOC_TYPE_TERM_CODE", _obj.getCode10()));
        elem.appendChild(this.createTextNodeElement("MOC_SERVICES_SUPPORTED", _obj.getSupport()));
        elem.appendChild(this.dimAttributeElement(obj));
        elem.appendChild(this.dimBehaviorElement(obj));
        elem.appendChild(this.dimNotificationElement(obj));
        for (DeviceObject childObj : this.getDimObjectChildren(_obj, dimObjectList)) {
            elem.appendChild(this.dimObjectElement(childObj, dimObjectList));
        }
        return elem;
    }

    protected List<DeviceObject> getDimObjectChildren(DeviceObject obj, List<DeviceObject> dimObjectList) {
        ArrayList<DeviceObject> retList = new ArrayList<DeviceObject>();
        for (DeviceObject itr : dimObjectList) {
            if (!itr.getParentId().equals(obj.getId())) continue;
            retList.add(itr);
        }
        return retList;
    }

    protected DeviceObject getRoot(List<DeviceObject> dimObjectList) {
        for (DeviceObject itr : dimObjectList) {
            if (!itr.getId().equals(0)) continue;
            return itr;
        }
        return null;
    }
}

