/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file;

import gov.nist.healthcare.deviceProfile.domain.common.JaxbUtils;
import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceInformation;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.ProfileInformation;
import gov.nist.healthcare.deviceProfile.domain.device.ProfileResume;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceEnumGroup;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnitGroup;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ProfileController {
    public static final String ProfileVersion = "0.1";
    private DeviceProfile _profile;

    public static DeviceProfile newProfile() {
        ProfileResume _resume = new ProfileResume();
        _resume.setVersion(ProfileVersion);
        DeviceProfile profile = new DeviceProfile();
        profile.setResume(_resume);
        return profile;
    }

    public DeviceProfile getProfile() {
        return this._profile;
    }

    public void setProfile(InputStream is) {
        try {
            DeviceProfile profile = (DeviceProfile)JaxbUtils.Unmarshall(DeviceProfile.class, (InputStream)is);
            if (profile != null) {
                this.setProfile(profile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProfile(DeviceProfile profile) {
        this._profile = this.updateProfile(profile);
    }

    public void toXml(OutputStream os) {
        try {
            JaxbUtils.Marshall((Object)this.getProfile(), (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toXml(String filename) {
        try {
            FileOutputStream os = new FileOutputStream(filename);
            this.toXml(os);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public DeviceProfile updateProfile(DeviceProfile profile) {
        if (profile.getResume().getVersion() == null) {
            this.movePItoResume(profile);
            this.moveDItoResume(profile);
            profile.getResume().setVersion(ProfileVersion);
        }
        this.moveUnitEnumToGroup(profile);
        this.migrateToName(profile);
        profile.trim();
        profile.updateObx4();
        profile.sort();
        return profile;
    }

    private void migrateToName(DeviceProfile profile) {
        for (DeviceObject obj : profile.getObjects()) {
            if ((obj.getName() == null || obj.getName().equals("")) && obj.getDisplayname() != null) {
                obj.setName(obj.getDisplayname());
            }
            obj.setDisplayname(null);
        }
    }

    private void moveDItoResume(DeviceProfile profile) {
        ProfileResume resume = profile.getResume();
        DeviceInformation di = resume.getDeviceInformation();
        if (di != null) {
            resume.setOid(di.getOID());
            resume.setDeviceType(di.getDeviceType());
            resume.setParentOIDs(di.getParentOIDs());
            resume.setProfileMode(di.getProfileMode());
            resume.setProfileType(di.getProfileType());
            resume.setTemplate(di.isTemplate());
            resume.setDeviceInformation(null);
        }
    }

    private void movePItoResume(DeviceProfile profile) {
        ProfileResume resume = profile.getResume();
        ProfileInformation pi = resume.getProfileBasicInformation();
        if (pi != null) {
            resume.setAuthor(pi.getAuthor());
            resume.setCompany(pi.getCompany());
            resume.setDateCreated(pi.getDateCreated());
            resume.setDateModified(pi.getDateModified());
            resume.setDescription(pi.getDescription());
            resume.setApplication_version(pi.getICSGeneratorVersion());
            resume.setTitle(pi.getTitle());
            resume.setVersion(pi.getVersion());
            resume.setProfileBasicInformation(null);
        }
    }

    private void moveUnitEnumToGroup(DeviceProfile profile) {
        for (DeviceObject obj : profile.getObjects()) {
            if (obj.getUnit().size() > 0) {
                obj.getUnitGroups().add(new DeviceUnitGroup("Unit List", obj.getUnit()));
                obj.getUnit().clear();
            }
            if (obj.getEnumSet().size() <= 0) continue;
            obj.getEnumGroups().add(new DeviceEnumGroup("Enumeration List", obj.getEnumSet()));
            obj.getEnumSet().clear();
        }
    }

    private void reorderObjects(DeviceProfile profile) {
        List<DeviceObject> retList = Collections.synchronizedList(new LinkedList());
        for (int i = 0; i < profile.getObjects().size(); ++i) {
            DeviceObject parent = (DeviceObject)profile.getObjects().get(i);
            System.out.println("reorder objects " + parent.getId() + " " + parent.getName());
            int id = parent.getId();
            if (id == i) {
                retList.add(parent);
                continue;
            }
            LinkedList children = MDOUtils.GetChildren((List)profile.getObjects(), (DeviceObject)parent);
            for (DeviceObject child : children) {
                child.setParentId(Integer.valueOf(i));
            }
            parent.setId(Integer.valueOf(i));
            retList.add(parent);
        }
        profile.setObjects(retList);
    }
}

