/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view;

import gov.nist.healthcare.mdc.icsgenerator.view.ElementTabbedView;
import gov.nist.healthcare.mdc.icsgenerator.view.OverviewTabbedView;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RightSidePanelView {
    private static final Logger log = Logger.getLogger(RightSidePanelView.class.getName());
    protected ElementTabbedView _tabbedView;
    protected CardLayout cardLayout;
    protected JScrollPane elementScrollPane;
    protected JComponent elementViewComponent;
    protected OverviewTabbedView overviewTabbed;
    protected JPanel rightSidePanel;

    public RightSidePanelView() {
        this.createGUI();
    }

    public void addElementPanel(String tag, JComponent panel) {
        if (this.elementViewComponent != null) {
            this.rightSidePanel.remove(this.elementViewComponent);
        }
        this.elementViewComponent = panel;
        this.rightSidePanel.add((Component)panel, tag);
    }

    public void createGUI() {
        this.rightSidePanel = new JPanel(new CardLayout());
        this.overviewTabbed = new OverviewTabbedView();
        this.overviewTabbed.initialize();
        this.rightSidePanel.add((Component)this.overviewTabbed.getView(), "Overview");
        this.rightSidePanel.add((Component)this.getElementView().getView(), "Element");
        this.cardLayout = (CardLayout)this.rightSidePanel.getLayout();
        this.showPanel("Element");
        this.elementScrollPane = new JScrollPane(this.rightSidePanel);
        this.elementScrollPane.setVerticalScrollBarPolicy(21);
        this.elementScrollPane.setHorizontalScrollBarPolicy(31);
    }

    public ElementTabbedView getElementView() {
        if (this._tabbedView == null) {
            this._tabbedView = new ElementTabbedView();
            this._tabbedView.initialize();
        }
        return this._tabbedView;
    }

    public JComponent getView() {
        return this.elementScrollPane;
    }

    public void refresh() {
        this.getElementView().refresh();
        this.overviewTabbed.refresh();
    }

    public void reset() {
        this.getElementView().reset();
        this.overviewTabbed.reset();
    }

    public void showPanel(String panelName) {
        this.cardLayout.show(this.rightSidePanel, panelName);
    }
}

