/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.box.panel;

import gov.nist.healthcare.mdc.applib.box.IBox;
import gov.nist.healthcare.mdc.applib.tabbed.TabbedView;
import gov.nist.healthcare.mdc.framework.mvc.AbsView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BoxesPanelCtl
extends AbsView {
    private static final Logger log = Logger.getLogger(BoxesPanelCtl.class.getName());
    protected List<IBox> boxList;
    private boolean tabbed = false;
    JPanel assemblyPanel;
    JPanel view = new JPanel();

    public BoxesPanelCtl() {
    }

    public BoxesPanelCtl(String boxName) {
        super(boxName);
    }

    public BoxesPanelCtl(String boxName, boolean tabbed) {
        super(boxName);
        this.tabbed = tabbed;
    }

    public void assembly() {
        if (this.getBoxList() != null) {
            JPanel assemblyPanel = this.getAssembly();
            this.getView().setLayout(new BorderLayout());
            this.getView().add((Component)assemblyPanel, "North");
        }
    }

    public void assemblyTabbed() {
        if (this.getBoxList() != null) {
            JComponent tabbedPane = this.getAssemblyTabbed();
            this.getView().setLayout(new BorderLayout());
            this.getView().add((Component)tabbedPane, "North");
        }
    }

    @Override
    public void createGUI() {
    }

    public JPanel getAssembly() {
        this.assemblyPanel = new JPanel();
        this.assemblyPanel.setLayout(new BoxLayout(this.assemblyPanel, 3));
        this.assemblyPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.assemblyPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        for (IBox comp : this.getBoxList()) {
            this.assemblyPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            JComponent compTmp = comp.getView();
            comps.put(comp, compTmp);
            this.assemblyPanel.add(compTmp);
            this.assemblyPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        this.assemblyPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        return this.assemblyPanel;
    }

    public JComponent getAssemblyTabbed() {
        TabbedView tabbedPane = new TabbedView();
        for (IBox comp : this.getBoxList()) {
            JComponent jcomp = comp.getView();
            comps.put(comp, jcomp);
            tabbedPane.add(comp.getName(), jcomp);
        }
        return tabbedPane.getView();
    }

    public List<IBox> getBoxList() {
        if (this.boxList == null) {
            this.boxList = new LinkedList<IBox>();
        }
        return this.boxList;
    }

    @Override
    public JComponent getView() {
        return this.view;
    }

    @Override
    public void refresh() {
        for (IBox box : this.getBoxList()) {
            box.refresh();
        }
    }

    @Override
    public void reset() {
        for (IBox box : this.getBoxList()) {
            box.reset();
        }
    }

    public void setBoxList(List<IBox> componentList) {
        this.boxList = componentList;
    }
}

