/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.dao.impl.x73.rosetta;

import gov.nist.healthcare.dev.profile.common.trace.TimeDiff;
import gov.nist.healthcare.dev.profile.dao.RosettaDao;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSEnumGroup;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSRosetta;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSUnitGroup;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RosettaDaoJPAImpl
implements RosettaDao {
    private static final Log log = LogFactory.getLog(RosettaDaoJPAImpl.class);

    public abstract EntityManager getEntityManager();

    @Override
    public List<ICSRosetta> find(String refid) {
        List ret = null;
        TimeDiff tdiff = new TimeDiff();
        refid = refid.replaceAll("\\_", "\\\\_");
        ret = this.getEntityManager().createQuery("SELECT e FROM ICSRosetta e WHERE  e.refid LIKE :refid ORDER BY e.status DESC ").setParameter("refid", (Object)("%" + refid + "%")).getResultList();
        log.info((Object)("find " + refid + " time consumes " + tdiff.getDiff()));
        return ret;
    }

    @Override
    public List<ICSRosetta> get(String refid) {
        List ret = null;
        ret = this.getEntityManager().createQuery("SELECT e FROM ICSRosetta e WHERE  e.refid LIKE :refid ORDER BY e.status DESC ").setParameter("refid", (Object)refid).getResultList();
        return ret;
    }

    public List<ICSEnumGroup> getEnumGroup() {
        return this.getEntityManager().createQuery("SELECT e FROM ICSEnumGroup e ORDER BY e.enum_group").getResultList();
    }

    @Override
    public List<ICSRosetta> getHarmonizedTerms(String refid) {
        List ret = this.getEntityManager().createQuery("SELECT e FROM ICSRosetta e WHERE e.status LIKE 'HARMONIZED' AND e.refid LIKE :refid ").setParameter("refid", (Object)refid).getResultList();
        return ret;
    }

    @Override
    public List<ICSRosetta> getProposedTerms(String refid) {
        return this.getEntityManager().createQuery("SELECT e FROM ICSRosetta e WHERE e.status LIKE 'PROPOSED' AND e.refid LIKE :refid ").setParameter("refid", (Object)refid).getResultList();
    }

    public List<ICSUnitGroup> getUnitGroup() {
        return this.getEntityManager().createQuery("SELECT e FROM ICSUnitGroup e ORDER BY e.unit_group").getResultList();
    }
}

